/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.dto.BatchCommonDTO;
import org.apache.shenyu.admin.model.dto.MetaDataDTO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageParameter;
import org.apache.shenyu.admin.model.query.MetaDataQuery;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.model.vo.MetaDataVO;
import org.apache.shenyu.admin.service.MetaDataService;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/meta-data"})
public class MetaDataController {
    private final MetaDataService metaDataService;

    public MetaDataController(MetaDataService metaDataService) {
        this.metaDataService = metaDataService;
    }

    @GetMapping(value={"/queryList"})
    public ShenyuAdminResult queryList(String appName, Integer currentPage, Integer pageSize) {
        CommonPager<MetaDataVO> commonPager = this.metaDataService.listByPage(new MetaDataQuery(appName, new PageParameter(currentPage, pageSize)));
        return ShenyuAdminResult.success("query success", commonPager);
    }

    @GetMapping(value={"/findAll"})
    public ShenyuAdminResult findAll() {
        return ShenyuAdminResult.success("query success", this.metaDataService.findAll());
    }

    @GetMapping(value={"/findAllGroup"})
    public ShenyuAdminResult findAllGroup() {
        return ShenyuAdminResult.success("query success", this.metaDataService.findAllGroup());
    }

    @GetMapping(value={"/{id}"})
    public ShenyuAdminResult editor(@PathVariable(value="id") String id) {
        MetaDataVO metaDataVO = this.metaDataService.findById(id);
        return ShenyuAdminResult.success("detail success", metaDataVO);
    }

    @PostMapping(value={"/createOrUpdate"})
    public ShenyuAdminResult createOrUpdate(@Valid @RequestBody MetaDataDTO metaDataDTO) {
        String result = this.metaDataService.createOrUpdate(metaDataDTO);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{result})) {
            return ShenyuAdminResult.error(result);
        }
        return ShenyuAdminResult.success("create success");
    }

    @PostMapping(value={"/batchDeleted"})
    public ShenyuAdminResult batchDeleted(@RequestBody @NotEmpty List<@NotBlank String> ids) {
        Integer deleteCount = this.metaDataService.delete(ids);
        return ShenyuAdminResult.success("delete success", deleteCount);
    }

    @PostMapping(value={"/batchEnabled"})
    public ShenyuAdminResult batchEnabled(@Valid @RequestBody BatchCommonDTO batchCommonDTO) {
        String result = this.metaDataService.enabled(batchCommonDTO.getIds(), batchCommonDTO.getEnabled());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{result})) {
            return ShenyuAdminResult.error(result);
        }
        return ShenyuAdminResult.success("enable success");
    }

    @PostMapping(value={"/syncData"})
    public ShenyuAdminResult syncData() {
        this.metaDataService.syncData();
        return ShenyuAdminResult.success();
    }
}

