/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.dto.AppAuthDTO;
import org.apache.shenyu.admin.model.dto.AuthApplyDTO;
import org.apache.shenyu.admin.model.dto.AuthPathWarpDTO;
import org.apache.shenyu.admin.model.dto.BatchCommonDTO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageParameter;
import org.apache.shenyu.admin.model.query.AppAuthQuery;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.model.vo.AppAuthVO;
import org.apache.shenyu.admin.service.AppAuthService;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/appAuth"})
public class AppAuthController {
    private final AppAuthService appAuthService;

    public AppAuthController(AppAuthService appAuthService) {
        this.appAuthService = appAuthService;
    }

    @PostMapping(value={"/apply"})
    public ShenyuAdminResult apply(@RequestBody AuthApplyDTO authApplyDTO) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{authApplyDTO.getAppKey()})) {
            return this.appAuthService.applyUpdate(authApplyDTO);
        }
        return this.appAuthService.applyCreate(authApplyDTO);
    }

    @GetMapping(value={"/updateSk"})
    public ShenyuAdminResult updateSk(@RequestParam(value="appKey") String appKey, @RequestParam(value="appSecret") String appSecret) {
        return this.appAuthService.updateAppSecretByAppKey(appKey, appSecret);
    }

    @GetMapping(value={"/findPageByQuery"})
    public ShenyuAdminResult findPageByQuery(String appKey, String phone, Integer currentPage, Integer pageSize) {
        AppAuthQuery query = new AppAuthQuery();
        query.setPhone(phone);
        query.setAppKey(appKey);
        query.setPageParameter(new PageParameter(currentPage, pageSize));
        CommonPager<AppAuthVO> commonPager = this.appAuthService.listByPage(query);
        return ShenyuAdminResult.success("query success", commonPager);
    }

    @GetMapping(value={"/detail"})
    public ShenyuAdminResult detail(@RequestParam(value="id") String id) {
        return ShenyuAdminResult.success("detail success", this.appAuthService.findById(id));
    }

    @PostMapping(value={"/updateDetail"})
    public ShenyuAdminResult updateDetail(@RequestBody AppAuthDTO appAuthDTO) {
        return this.appAuthService.updateDetail(appAuthDTO);
    }

    @GetMapping(value={"/detailPath"})
    public ShenyuAdminResult detailPath(@RequestParam(value="id") @NotBlank String id) {
        return ShenyuAdminResult.success("detail success", this.appAuthService.detailPath(id));
    }

    @PostMapping(value={"/updateDetailPath"})
    public ShenyuAdminResult updateDetailPath(@RequestBody AuthPathWarpDTO authPathWarpDTO) {
        return this.appAuthService.updateDetailPath(authPathWarpDTO);
    }

    @PostMapping(value={"/batchDelete"})
    public ShenyuAdminResult batchDelete(@RequestBody @NotEmpty List<@NotBlank String> ids) {
        Integer deleteCount = this.appAuthService.delete(ids);
        return ShenyuAdminResult.success("delete success", deleteCount);
    }

    @PostMapping(value={"/batchEnabled"})
    public ShenyuAdminResult batchEnabled(@Valid @RequestBody BatchCommonDTO batchCommonDTO) {
        String result = this.appAuthService.enabled(batchCommonDTO.getIds(), batchCommonDTO.getEnabled());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{result})) {
            return ShenyuAdminResult.error(result);
        }
        return ShenyuAdminResult.success("enable success");
    }

    @PostMapping(value={"/syncData"})
    public ShenyuAdminResult syncData() {
        return this.appAuthService.syncData();
    }
}

