/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.aspect;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.Objects;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageParameter;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.ReflectUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class PageableAspect {
    @Pointcut(value="@annotation(org.apache.shenyu.admin.aspect.annotation.Pageable)")
    public void pageableCut() {
    }

    @Around(value="pageableCut()")
    public Object mapperAround(ProceedingJoinPoint point) {
        try {
            Object query = point.getArgs()[0];
            PageParameter pageParameter = (PageParameter)ReflectUtils.getFieldValue((Object)query, (String)"pageParameter");
            if (Objects.isNull(pageParameter)) {
                return point.proceed();
            }
            Page page = PageHelper.startPage((int)pageParameter.getCurrentPage(), (int)pageParameter.getPageSize());
            Object proceed = point.proceed();
            CommonPager commonPager = (CommonPager)proceed;
            PageParameter result = commonPager.getPage();
            result = this.convert(page, result);
            commonPager.setPage(result);
            return proceed;
        }
        catch (Throwable throwable) {
            throw new ShenyuException(throwable);
        }
    }

    public PageParameter convert(Page<?> pageInfo, PageParameter pageParameter) {
        pageParameter.setCurrentPage(pageInfo.getPageNum());
        pageParameter.setPageSize(pageInfo.getPageSize());
        pageParameter.setTotalPage(pageInfo.getPages());
        pageParameter.setTotalCount((int)pageInfo.getTotal());
        pageParameter.setOffset(pageInfo.getPageSize());
        return pageParameter;
    }
}

