/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.register.server.etcd;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.register.common.config.ShenyuRegisterCenterConfig;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.common.path.RegisterPathConstants;
import org.apache.shenyu.register.server.api.ShenyuServerRegisterPublisher;
import org.apache.shenyu.register.server.api.ShenyuServerRegisterRepository;
import org.apache.shenyu.register.server.etcd.client.EtcdClient;
import org.apache.shenyu.register.server.etcd.client.EtcdListenHandler;
import org.apache.shenyu.spi.Join;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Join
public class EtcdServerRegisterRepository
implements ShenyuServerRegisterRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(EtcdServerRegisterRepository.class);
    private ShenyuServerRegisterPublisher publisher;
    private EtcdClient client;

    public void init(ShenyuServerRegisterPublisher publisher, ShenyuRegisterCenterConfig config) {
        this.client = new EtcdClient(config.getServerLists());
        this.publisher = publisher;
        this.initSubscribe();
    }

    public void close() {
        this.client.close();
    }

    private void initSubscribe() {
        RpcTypeEnum.acquireSupportMetadatas().forEach(rpcTypeEnum -> this.subscribeMetaData(rpcTypeEnum.getName()));
        RpcTypeEnum.acquireSupportURIs().forEach(rpcTypeEnum -> this.subscribeURI(rpcTypeEnum.getName()));
    }

    private void subscribeMetaData(String rpcType) {
        String rpcPath = RegisterPathConstants.buildMetaDataContextPathParent((String)rpcType);
        List<String> metadataPaths = this.client.getChildren(rpcPath);
        for (String metadataPath : metadataPaths) {
            String data = this.client.read(metadataPath);
            this.publishMetadata(data);
        }
        LOGGER.info("subscribe metadata change: {}", (Object)rpcPath);
        this.client.subscribeChildChanges(rpcPath, new EtcdListenHandler(){

            @Override
            public void updateHandler(String path, String value) {
                EtcdServerRegisterRepository.this.publishMetadata(EtcdServerRegisterRepository.this.client.read(path));
            }

            @Override
            public void deleteHandler(String path, String value) {
            }
        });
    }

    private void publishMetadata(String metadataData) {
        this.publisher.publish((Object)Lists.newArrayList((Object[])new MetaDataRegisterDTO[]{(MetaDataRegisterDTO)GsonUtils.getInstance().fromJson(metadataData, MetaDataRegisterDTO.class)}));
    }

    private void subscribeURI(String rpcType) {
        final String rpcPath = RegisterPathConstants.buildURIContextPathParent((String)rpcType);
        HashSet contextList = new HashSet();
        this.client.getChildren(rpcPath).forEach(dataPath -> {
            String context = dataPath.split("/")[4];
            contextList.add(context);
        });
        contextList.forEach(context -> this.registerUriChildrenList(rpcPath, (String)context));
        LOGGER.info("subscribe uri change: {}", (Object)rpcPath);
        this.client.subscribeChildChanges(rpcPath, new EtcdListenHandler(){

            @Override
            public void updateHandler(String path, String value) {
                String[] paths = path.split("/");
                EtcdServerRegisterRepository.this.registerUriChildrenList(rpcPath, paths[4]);
            }

            @Override
            public void deleteHandler(String path, String value) {
                String[] paths = path.split("/");
                EtcdServerRegisterRepository.this.registerUriChildrenList(rpcPath, paths[4]);
            }
        });
    }

    private void registerUriChildrenList(String rpcPath, String context) {
        String contextPath = String.join((CharSequence)"/", rpcPath, context);
        ArrayList<URIRegisterDTO> uriRegisterDTOList = new ArrayList<URIRegisterDTO>();
        this.client.getChildren(contextPath).forEach(path -> uriRegisterDTOList.add((URIRegisterDTO)GsonUtils.getInstance().fromJson(this.client.read((String)path), URIRegisterDTO.class)));
        if (uriRegisterDTOList.isEmpty()) {
            URIRegisterDTO uriRegisterDTO = URIRegisterDTO.builder().contextPath("/" + context).build();
            uriRegisterDTOList.add(uriRegisterDTO);
        }
        this.publishURI(uriRegisterDTOList);
    }

    private void publishURI(List<URIRegisterDTO> registerDTOList) {
        this.publisher.publish(registerDTOList);
    }
}

