/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.insert;

import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.insert.InsertModifierPriority;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;

public class Insert
implements Statement {
    private Table table;
    private List<Column> columns;
    private ItemsList itemsList;
    private boolean useValues = true;
    private Select select;
    private boolean useSelectBrackets = true;
    private boolean useDuplicate = false;
    private List<Column> duplicateUpdateColumns;
    private List<Expression> duplicateUpdateExpressionList;
    private InsertModifierPriority modifierPriority = null;
    private boolean modifierIgnore = false;
    private boolean returningAllColumns = false;
    private List<SelectExpressionItem> returningExpressionList = null;

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table name) {
        this.table = name;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public void setColumns(List<Column> list) {
        this.columns = list;
    }

    public ItemsList getItemsList() {
        return this.itemsList;
    }

    public void setItemsList(ItemsList list) {
        this.itemsList = list;
    }

    public boolean isUseValues() {
        return this.useValues;
    }

    public void setUseValues(boolean useValues) {
        this.useValues = useValues;
    }

    public boolean isReturningAllColumns() {
        return this.returningAllColumns;
    }

    public void setReturningAllColumns(boolean returningAllColumns) {
        this.returningAllColumns = returningAllColumns;
    }

    public List<SelectExpressionItem> getReturningExpressionList() {
        return this.returningExpressionList;
    }

    public void setReturningExpressionList(List<SelectExpressionItem> returningExpressionList) {
        this.returningExpressionList = returningExpressionList;
    }

    public Select getSelect() {
        return this.select;
    }

    public void setSelect(Select select) {
        this.select = select;
    }

    public boolean isUseSelectBrackets() {
        return this.useSelectBrackets;
    }

    public void setUseSelectBrackets(boolean useSelectBrackets) {
        this.useSelectBrackets = useSelectBrackets;
    }

    public boolean isUseDuplicate() {
        return this.useDuplicate;
    }

    public void setUseDuplicate(boolean useDuplicate) {
        this.useDuplicate = useDuplicate;
    }

    public List<Column> getDuplicateUpdateColumns() {
        return this.duplicateUpdateColumns;
    }

    public void setDuplicateUpdateColumns(List<Column> duplicateUpdateColumns) {
        this.duplicateUpdateColumns = duplicateUpdateColumns;
    }

    public List<Expression> getDuplicateUpdateExpressionList() {
        return this.duplicateUpdateExpressionList;
    }

    public void setDuplicateUpdateExpressionList(List<Expression> duplicateUpdateExpressionList) {
        this.duplicateUpdateExpressionList = duplicateUpdateExpressionList;
    }

    public InsertModifierPriority getModifierPriority() {
        return this.modifierPriority;
    }

    public void setModifierPriority(InsertModifierPriority modifierPriority) {
        this.modifierPriority = modifierPriority;
    }

    public boolean isModifierIgnore() {
        return this.modifierIgnore;
    }

    public void setModifierIgnore(boolean modifierIgnore) {
        this.modifierIgnore = modifierIgnore;
    }

    public String toString() {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT ");
        if (this.modifierPriority != null) {
            sql.append(this.modifierPriority.name()).append(" ");
        }
        if (this.modifierIgnore) {
            sql.append("IGNORE ");
        }
        sql.append("INTO ");
        sql.append(this.table).append(" ");
        if (this.columns != null) {
            sql.append(PlainSelect.getStringList(this.columns, true, true)).append(" ");
        }
        if (this.useValues) {
            sql.append("VALUES ");
        }
        if (this.itemsList != null) {
            sql.append(this.itemsList);
        } else {
            if (this.useSelectBrackets) {
                sql.append("(");
            }
            if (this.select != null) {
                sql.append(this.select);
            }
            if (this.useSelectBrackets) {
                sql.append(")");
            }
        }
        if (this.useDuplicate) {
            sql.append(" ON DUPLICATE KEY UPDATE ");
            for (int i = 0; i < this.getDuplicateUpdateColumns().size(); ++i) {
                if (i != 0) {
                    sql.append(", ");
                }
                sql.append(this.duplicateUpdateColumns.get(i)).append(" = ");
                sql.append(this.duplicateUpdateExpressionList.get(i));
            }
        }
        if (this.isReturningAllColumns()) {
            sql.append(" RETURNING *");
        } else if (this.getReturningExpressionList() != null) {
            sql.append(" RETURNING ").append(PlainSelect.getStringList(this.getReturningExpressionList(), true, false));
        }
        return sql.toString();
    }
}

