/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.register.server.zookeeper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.I0Itec.zkclient.IZkDataListener;
import org.I0Itec.zkclient.ZkClient;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.CollectionUtils;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.register.common.config.ShenyuRegisterCenterConfig;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.common.path.RegisterPathConstants;
import org.apache.shenyu.register.server.api.ShenyuServerRegisterPublisher;
import org.apache.shenyu.register.server.api.ShenyuServerRegisterRepository;
import org.apache.shenyu.spi.Join;

@Join
public class ZookeeperServerRegisterRepository
implements ShenyuServerRegisterRepository {
    private ShenyuServerRegisterPublisher publisher;
    private ZkClient zkClient;

    public void init(ShenyuServerRegisterPublisher publisher, ShenyuRegisterCenterConfig config) {
        this.init(config);
        this.publisher = publisher;
        Properties props = config.getProps();
        int sessionTimeout = Integer.parseInt(props.getProperty("sessionTimeout", "30000"));
        int connectionTimeout = Integer.parseInt(props.getProperty("connectionTimeout", "3000"));
        this.zkClient = new ZkClient(config.getServerLists(), sessionTimeout, connectionTimeout);
        this.initSubscribe();
    }

    public void close() {
        this.zkClient.close();
    }

    private void initSubscribe() {
        RpcTypeEnum.acquireSupportMetadatas().forEach(rpcTypeEnum -> this.subscribeMetaData(rpcTypeEnum.getName()));
        RpcTypeEnum.acquireSupportURIs().forEach(rpcTypeEnum -> this.subscribeURI(rpcTypeEnum.getName()));
    }

    private void subscribeURI(String rpcType) {
        String contextPathParent = RegisterPathConstants.buildURIContextPathParent((String)rpcType);
        List<String> contextPaths = this.zkClientGetChildren(contextPathParent);
        for (String contextPath : contextPaths) {
            this.watcherURI(rpcType, contextPath);
        }
        this.zkClient.subscribeChildChanges(contextPathParent, (parentPath, currentChildren) -> {
            if (CollectionUtils.isNotEmpty((Collection)currentChildren)) {
                for (String contextPath : currentChildren) {
                    this.watcherURI(rpcType, contextPath);
                }
            }
        });
    }

    private void subscribeMetaData(String rpcType) {
        String contextPathParent = RegisterPathConstants.buildMetaDataContextPathParent((String)rpcType);
        List<String> contextPaths = this.zkClientGetChildren(contextPathParent);
        for (String contextPath : contextPaths) {
            this.watcherMetadata(rpcType, contextPath);
        }
        this.zkClient.subscribeChildChanges(contextPathParent, (parentPath, currentChildren) -> {
            if (CollectionUtils.isNotEmpty((Collection)currentChildren)) {
                for (String contextPath : currentChildren) {
                    this.watcherMetadata(rpcType, contextPath);
                }
            }
        });
    }

    private void watcherMetadata(String rpcType, String contextPath) {
        String metaDataParentPath = RegisterPathConstants.buildMetaDataParentPath((String)rpcType, (String)contextPath);
        List<String> childrenList = this.zkClientGetChildren(metaDataParentPath);
        if (CollectionUtils.isNotEmpty(childrenList)) {
            childrenList.forEach(children -> {
                String realPath = RegisterPathConstants.buildRealNode((String)metaDataParentPath, (String)children);
                this.publishMetadata(this.zkClient.readData(realPath).toString());
                this.subscribeMetaDataChanges(realPath);
            });
        }
        this.zkClient.subscribeChildChanges(metaDataParentPath, (parentPath, currentChildren) -> {
            if (CollectionUtils.isNotEmpty((Collection)currentChildren)) {
                List<String> addSubscribePath = this.addSubscribePath(childrenList, currentChildren);
                addSubscribePath.stream().map(addPath -> {
                    String realPath = RegisterPathConstants.buildRealNode((String)parentPath, (String)addPath);
                    this.publishMetadata(this.zkClient.readData(realPath).toString());
                    return realPath;
                }).forEach(this::subscribeMetaDataChanges);
            }
        });
    }

    private void watcherURI(String rpcType, String contextPath) {
        String uriParentPath = RegisterPathConstants.buildURIParentPath((String)rpcType, (String)contextPath);
        List<String> childrenList = this.zkClientGetChildren(uriParentPath);
        if (CollectionUtils.isNotEmpty(childrenList)) {
            this.registerURIChildrenList(childrenList, uriParentPath);
        }
        this.zkClient.subscribeChildChanges(uriParentPath, (parentPath, currentChildren) -> {
            if (CollectionUtils.isNotEmpty((Collection)currentChildren)) {
                this.registerURIChildrenList(currentChildren, parentPath);
            } else {
                this.registerURIChildrenList(new ArrayList<String>(), parentPath);
            }
        });
    }

    private void registerURIChildrenList(List<String> childrenList, String uriParentPath) {
        ArrayList<URIRegisterDTO> registerDTOList = new ArrayList<URIRegisterDTO>();
        childrenList.forEach(addPath -> {
            String realPath = RegisterPathConstants.buildRealNode((String)uriParentPath, (String)addPath);
            registerDTOList.add((URIRegisterDTO)GsonUtils.getInstance().fromJson(this.zkClient.readData(realPath).toString(), URIRegisterDTO.class));
        });
        if (registerDTOList.isEmpty()) {
            String contextPath = StringUtils.substringAfterLast((String)uriParentPath, (String)"/");
            URIRegisterDTO uriRegisterDTO = URIRegisterDTO.builder().contextPath("/" + contextPath).build();
            registerDTOList.add(uriRegisterDTO);
        }
        this.publishRegisterURI(registerDTOList);
    }

    private void subscribeMetaDataChanges(String realPath) {
        this.zkClient.subscribeDataChanges(realPath, new IZkDataListener(){

            public void handleDataChange(String dataPath, Object data) {
                ZookeeperServerRegisterRepository.this.publishMetadata(data.toString());
            }

            public void handleDataDeleted(String dataPath) {
            }
        });
    }

    private void publishMetadata(String data) {
        this.publisher.publish((Object)Lists.newArrayList((Object[])new MetaDataRegisterDTO[]{(MetaDataRegisterDTO)GsonUtils.getInstance().fromJson(data, MetaDataRegisterDTO.class)}));
    }

    private void publishRegisterURI(List<URIRegisterDTO> registerDTOList) {
        this.publisher.publish(registerDTOList);
    }

    private List<String> zkClientGetChildren(String parent) {
        if (!this.zkClient.exists(parent)) {
            this.zkClient.createPersistent(parent, true);
        }
        return this.zkClient.getChildren(parent);
    }

    private List<String> addSubscribePath(List<String> alreadyChildren, List<String> currentChildren) {
        if (CollectionUtils.isEmpty(alreadyChildren)) {
            return currentChildren;
        }
        return currentChildren.stream().filter(current -> alreadyChildren.stream().noneMatch(current::equals)).collect(Collectors.toList());
    }
}

