/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.register.server.consul;

import com.ecwid.consul.v1.kv.model.GetValue;
import com.google.common.collect.Lists;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.register.common.config.ShenyuRegisterCenterConfig;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.server.api.ShenyuServerRegisterPublisher;
import org.apache.shenyu.register.server.api.ShenyuServerRegisterRepository;
import org.apache.shenyu.register.server.consul.ConsulConfigChangedEvent;
import org.apache.shenyu.spi.Join;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryClient;
import org.springframework.context.event.EventListener;

@Join
public class ConsulServerRegisterRepository
implements ShenyuServerRegisterRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsulServerRegisterRepository.class);
    @Autowired
    private ConsulDiscoveryClient discoveryClient;
    private long index;
    private Map<String, List<URIRegisterDTO>> uriRegisterDTOMap = new HashMap<String, List<URIRegisterDTO>>();
    private ShenyuServerRegisterPublisher publisher;
    private final Map<String, Long> indexMap = new HashMap<String, Long>();

    public void init(ShenyuServerRegisterPublisher publisher, ShenyuRegisterCenterConfig config) {
        this.publisher = publisher;
    }

    @EventListener
    public void onInstanceChange(HeartbeatEvent event) {
        long i = Long.parseLong(event.getValue().toString());
        if (i > this.index) {
            this.index = i;
            Map<String, List<URIRegisterDTO>> uriMap = this.fetchInstancesMap();
            MapDifference difference = Maps.difference(uriMap, this.uriRegisterDTOMap);
            difference.entriesOnlyOnLeft().forEach(this::publishRegisterURI);
            difference.entriesOnlyOnRight().keySet().forEach(contextPath -> this.publishRegisterURI((String)contextPath, (List<URIRegisterDTO>)new ArrayList<URIRegisterDTO>()));
            difference.entriesDiffering().forEach((contextPath, listValueDifference) -> this.publishRegisterURI((String)contextPath, (List)listValueDifference.leftValue()));
            this.uriRegisterDTOMap = uriMap;
        }
    }

    @EventListener
    public void onMetadataChange(ConsulConfigChangedEvent event) {
        Map<String, GetValue> metadataMap = event.getMetadataMap();
        metadataMap.forEach((path, getValue) -> {
            long modifyIndex = getValue.getModifyIndex();
            if (this.metadataChanged((String)path, modifyIndex)) {
                this.publishMetadata(getValue.getDecodedValue());
            }
        });
    }

    private void publishMetadata(String data) {
        this.publisher.publish((Object)Lists.newArrayList((Object[])new MetaDataRegisterDTO[]{(MetaDataRegisterDTO)GsonUtils.getInstance().fromJson(data, MetaDataRegisterDTO.class)}));
    }

    private void publishRegisterURI(String contextPath, List<URIRegisterDTO> registerDTOList) {
        if (registerDTOList.isEmpty()) {
            URIRegisterDTO uriRegisterDTO = URIRegisterDTO.builder().contextPath(contextPath).build();
            registerDTOList.add(uriRegisterDTO);
        }
        this.publisher.publish(registerDTOList);
    }

    private Map<String, List<URIRegisterDTO>> fetchInstancesMap() {
        HashMap<String, List<URIRegisterDTO>> map = new HashMap<String, List<URIRegisterDTO>>();
        List instances = this.discoveryClient.getAllInstances();
        instances.forEach(serviceInstance -> {
            String data = (String)serviceInstance.getMetadata().get("uri");
            if (null != data) {
                URIRegisterDTO uriRegisterDTO = (URIRegisterDTO)GsonUtils.getInstance().fromJson(data, URIRegisterDTO.class);
                String contextPath = uriRegisterDTO.getContextPath();
                map.putIfAbsent(contextPath, new ArrayList());
                ((List)map.get(contextPath)).add(uriRegisterDTO);
            } else {
                LOGGER.debug("maybe not shenyu client, ignore service instance: {}", serviceInstance);
            }
        });
        return map;
    }

    private boolean metadataChanged(String path, long index) {
        boolean result;
        boolean bl = result = !this.indexMap.containsKey(path) || this.indexMap.get(path) < index;
        if (result) {
            this.indexMap.put(path, index);
        }
        return result;
    }
}

