/*
 * Decompiled with CFR 0.152.
 */
package reactor.queue;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import reactor.function.Function;
import reactor.function.Supplier;
import reactor.queue.QueuePersistor;

public class InMemoryQueuePersistor<T>
implements QueuePersistor<T> {
    private final Map<Long, T> objects = Collections.synchronizedMap(new HashMap());
    private final AtomicLong counter = new AtomicLong();
    private final AtomicLong currentId = new AtomicLong();
    private final Function<T, Long> offerFun = new MapOfferFunction();
    private final Function<Long, T> getFun = new MapGetFunction();
    private final Supplier<T> removeFun = new MapRemoveFunction();

    @Override
    public long lastId() {
        return this.currentId.get();
    }

    @Override
    public long size() {
        return this.objects.size();
    }

    @Override
    public boolean hasNext() {
        return !this.objects.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.objects.values().iterator();
    }

    @Override
    @Nonnull
    public Function<T, Long> offer() {
        return this.offerFun;
    }

    @Override
    @Nonnull
    public Function<Long, T> get() {
        return this.getFun;
    }

    @Override
    @Nonnull
    public Supplier<T> remove() {
        return this.removeFun;
    }

    @Override
    public void close() {
    }

    private class MapRemoveFunction
    implements Supplier<T> {
        private MapRemoveFunction() {
        }

        @Override
        public T get() {
            Long id = InMemoryQueuePersistor.this.currentId.getAndIncrement();
            return InMemoryQueuePersistor.this.objects.remove(id);
        }
    }

    private class MapGetFunction
    implements Function<Long, T> {
        private MapGetFunction() {
        }

        @Override
        public T apply(Long l) {
            return InMemoryQueuePersistor.this.objects.get(l);
        }
    }

    private class MapOfferFunction
    implements Function<T, Long> {
        private MapOfferFunction() {
        }

        @Override
        public Long apply(T obj) {
            Long id = InMemoryQueuePersistor.this.counter.getAndIncrement();
            InMemoryQueuePersistor.this.objects.put(id, obj);
            return id;
        }
    }
}

