/*
 * Decompiled with CFR 0.152.
 */
package reactor.pool;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import reactor.function.Supplier;
import reactor.pool.Pool;
import reactor.queue.BlockingQueueFactory;

public class LoadingPool<T>
implements Pool<T> {
    private final BlockingQueue<T> cache = BlockingQueueFactory.createQueue();
    private final Supplier<T> supplier;
    private final long cacheMissTimeout;

    public LoadingPool(Supplier<T> supplier, int initial, long cacheMissTimeout) {
        this.supplier = supplier;
        this.cacheMissTimeout = cacheMissTimeout;
        for (int i = 0; i < initial; ++i) {
            this.cache.add(supplier.get());
        }
    }

    @Override
    @Nullable
    public T allocate() {
        try {
            T obj;
            long start = System.currentTimeMillis();
            while (null == (obj = this.cache.poll(this.cacheMissTimeout, TimeUnit.MILLISECONDS)) && System.currentTimeMillis() - start < this.cacheMissTimeout) {
            }
            return null != obj ? obj : this.supplier.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return this.supplier.get();
        }
    }

    @Override
    public void deallocate(T obj) {
        this.cache.add(obj);
    }
}

