/*
 * Decompiled with CFR 0.152.
 */
package reactor.function;

import java.lang.reflect.Constructor;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import reactor.function.Consumer;
import reactor.function.Function;
import reactor.function.Supplier;

public abstract class Functions {
    @SafeVarargs
    public static final <T> Consumer<T> chain(Consumer<T> ... consumers) {
        final AtomicReference<Consumer<T>> composition = new AtomicReference<Consumer<T>>();
        for (final Consumer<T> next : consumers) {
            if (null == composition.get()) {
                composition.set(next);
                continue;
            }
            composition.set(new Consumer<T>(){
                final Consumer<T> prev;
                {
                    this.prev = (Consumer)composition.get();
                }

                @Override
                public void accept(T t) {
                    this.prev.accept(t);
                    next.accept(t);
                }
            });
        }
        return (Consumer)composition.get();
    }

    public static <T, V> Function<T, V> function(final Callable<V> c) {
        return new Function<T, V>(){

            @Override
            public V apply(T o) {
                try {
                    return c.call();
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        };
    }

    public static <T> Consumer<T> consumer(final Runnable r) {
        return new Consumer<T>(){

            @Override
            public void accept(T t) {
                r.run();
            }
        };
    }

    public static <T> Supplier<T> supplier(final T value) {
        return new Supplier<T>(){

            @Override
            public T get() {
                return value;
            }
        };
    }

    public static <T> Supplier<T> supplier(Class<T> type) {
        try {
            final Constructor<T> ctor = type.getConstructor(new Class[0]);
            return new Supplier<T>(){

                @Override
                public T get() {
                    try {
                        return ctor.newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e.getMessage(), e);
                    }
                }
            };
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static <T> Supplier<T> supplier(final Callable<T> callable) {
        return new Supplier<T>(){

            @Override
            public T get() {
                try {
                    return callable.call();
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        };
    }

    public static <T> Supplier<T> supplier(final Future<T> future) {
        return new Supplier<T>(){

            @Override
            public T get() {
                try {
                    return future.get();
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        };
    }
}

