/*
 * Decompiled with CFR 0.152.
 */
package reactor.event.selector;

import java.util.SortedSet;
import java.util.UUID;
import reactor.event.selector.HeaderResolver;
import reactor.event.selector.Selector;
import reactor.util.UUIDUtils;

public class ObjectSelector<T>
implements Selector {
    private final UUID uuid = UUIDUtils.create();
    private final Object monitor = new Object();
    private final T object;
    private SortedSet<String> tags;

    public ObjectSelector(T object) {
        this.object = object;
    }

    public static <T> Selector objectSelector(T obj) {
        return new ObjectSelector<T>(obj);
    }

    @Override
    public UUID getId() {
        return this.uuid;
    }

    public T getObject() {
        return this.object;
    }

    @Override
    public boolean matches(Object key) {
        return (null != this.object || null == key) && this.object != null && this.object.equals(key);
    }

    @Override
    public HeaderResolver getHeaderResolver() {
        return null;
    }

    protected Object clone() throws CloneNotSupportedException {
        return new ObjectSelector<T>(this.object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.monitor;
        synchronized (object) {
            return "Selector{object=" + this.object + ", uuid=" + this.uuid + ", tags=" + this.tags + '}';
        }
    }
}

