/*
 * Decompiled with CFR 0.152.
 */
package reactor.event.dispatch;

import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.event.Event;
import reactor.event.dispatch.Dispatcher;
import reactor.event.registry.Registry;
import reactor.event.routing.EventRouter;
import reactor.function.Consumer;
import reactor.util.Assert;

public class TraceableDelegatingDispatcher
implements Dispatcher {
    private final Dispatcher delegate;
    private final Logger log;

    public TraceableDelegatingDispatcher(Dispatcher delegate) {
        Assert.notNull(delegate, "Delegate Dispatcher cannot be null.");
        this.delegate = delegate;
        this.log = LoggerFactory.getLogger(delegate.getClass());
    }

    @Override
    public boolean alive() {
        return this.delegate.alive();
    }

    @Override
    public boolean awaitAndShutdown() {
        if (this.log.isTraceEnabled()) {
            this.log.trace("awaitAndShutdown()");
        }
        return this.delegate.awaitAndShutdown();
    }

    @Override
    public boolean awaitAndShutdown(long timeout, TimeUnit timeUnit) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("awaitAndShutdown({}, {})", (Object)timeout, (Object)timeUnit);
        }
        return this.delegate.awaitAndShutdown(timeout, timeUnit);
    }

    @Override
    public void shutdown() {
        if (this.log.isTraceEnabled()) {
            this.log.trace("shutdown()");
        }
        this.delegate.shutdown();
    }

    @Override
    public void halt() {
        if (this.log.isTraceEnabled()) {
            this.log.trace("halt()");
        }
        this.delegate.halt();
    }

    @Override
    public <E extends Event<?>> void dispatch(Object key, E event, Registry<Consumer<? extends Event<?>>> consumerRegistry, Consumer<Throwable> errorConsumer, EventRouter eventRouter, Consumer<E> completionConsumer) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("dispatch({}, {}, {}, {}, {}, {})", new Object[]{key, event, consumerRegistry, errorConsumer, eventRouter, completionConsumer});
        }
        this.delegate.dispatch(key, event, consumerRegistry, errorConsumer, eventRouter, completionConsumer);
    }

    @Override
    public <E extends Event<?>> void dispatch(E event, EventRouter eventRouter, Consumer<E> consumer, Consumer<Throwable> errorConsumer) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("dispatch({}, {}, {}, {})", new Object[]{event, eventRouter, consumer, errorConsumer});
        }
        this.delegate.dispatch(event, eventRouter, consumer, errorConsumer);
    }
}

