/*
 * Decompiled with CFR 0.152.
 */
package reactor.event.dispatch;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import reactor.event.Event;
import reactor.event.dispatch.BaseDispatcher;
import reactor.event.dispatch.BaseLifecycleDispatcher;
import reactor.function.Supplier;
import reactor.pool.LoadingPool;
import reactor.pool.Pool;
import reactor.support.NamedDaemonThreadFactory;

public final class ThreadPoolExecutorDispatcher
extends BaseLifecycleDispatcher {
    private final ExecutorService executor;
    private final Pool<ThreadPoolTask> readyTasks;

    public ThreadPoolExecutorDispatcher(int poolSize, int backlog) {
        this(poolSize, backlog, "thread-pool-executor-dispatcher");
    }

    public ThreadPoolExecutorDispatcher(int poolSize, int backlog, String threadName) {
        this.executor = Executors.newFixedThreadPool(poolSize, new NamedDaemonThreadFactory(threadName));
        this.readyTasks = new LoadingPool<ThreadPoolTask>(new Supplier<ThreadPoolTask>(){

            @Override
            public ThreadPoolTask get() {
                return new ThreadPoolTask();
            }
        }, backlog, 200L);
    }

    @Override
    public boolean awaitAndShutdown(long timeout, TimeUnit timeUnit) {
        this.shutdown();
        try {
            return this.executor.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
        super.shutdown();
    }

    @Override
    public void halt() {
        this.executor.shutdownNow();
        super.halt();
    }

    @Override
    protected <E extends Event<?>> BaseDispatcher.Task<E> createTask() {
        BaseDispatcher.Task t = this.readyTasks.allocate();
        return null != t ? t : new ThreadPoolTask();
    }

    private class ThreadPoolTask
    extends BaseDispatcher.Task<Event<Object>>
    implements Runnable {
        private ThreadPoolTask() {
            super(ThreadPoolExecutorDispatcher.this);
        }

        @Override
        public void submit() {
            ThreadPoolExecutorDispatcher.this.executor.submit(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.execute();
            }
            finally {
                ThreadPoolExecutorDispatcher.this.readyTasks.deallocate(this);
            }
        }
    }
}

