/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.processor.spec;

import reactor.core.processor.Processor;
import reactor.event.registry.CachingRegistry;
import reactor.event.registry.Registry;
import reactor.event.selector.Selectors;
import reactor.function.Consumer;
import reactor.function.Supplier;
import reactor.util.Assert;

public class ProcessorSpec<T>
implements Supplier<Processor<T>> {
    private Registry<Consumer<Throwable>> errorConsumers = new CachingRegistry<Consumer<Throwable>>();
    private boolean multiThreadedProducer = false;
    private int dataBufferSize = -1;
    private Supplier<T> dataSupplier;
    private Consumer<T> consumer;

    public ProcessorSpec<T> multiThreadedProducer() {
        this.multiThreadedProducer = true;
        return this;
    }

    public ProcessorSpec<T> singleThreadedProducer() {
        this.multiThreadedProducer = false;
        return this;
    }

    public ProcessorSpec<T> dataBufferSize(int dataBufferSize) {
        this.dataBufferSize = dataBufferSize;
        return this;
    }

    public ProcessorSpec<T> dataSupplier(Supplier<T> dataSupplier) {
        Assert.isNull(this.dataSupplier, "Data Supplier is already set.");
        this.dataSupplier = dataSupplier;
        return this;
    }

    public ProcessorSpec<T> consume(Consumer<T> consumer) {
        this.consumer = consumer;
        return this;
    }

    public ProcessorSpec<T> when(Class<? extends Throwable> type, Consumer<Throwable> errorConsumer) {
        this.errorConsumers.register(Selectors.type(type), errorConsumer);
        return this;
    }

    @Override
    public Processor<T> get() {
        return new Processor<T>(this.dataSupplier, this.consumer, this.errorConsumers, this.multiThreadedProducer, this.dataBufferSize);
    }
}

