/*
 * Decompiled with CFR 0.152.
 */
package reactor.core;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Observable;
import reactor.event.Event;
import reactor.event.dispatch.Dispatcher;
import reactor.event.dispatch.SynchronousDispatcher;
import reactor.event.registry.CachingRegistry;
import reactor.event.registry.Registration;
import reactor.event.registry.Registry;
import reactor.event.routing.ArgumentConvertingConsumerInvoker;
import reactor.event.routing.ConsumerFilteringEventRouter;
import reactor.event.routing.EventRouter;
import reactor.event.routing.Linkable;
import reactor.event.selector.ClassSelector;
import reactor.event.selector.Selector;
import reactor.event.selector.Selectors;
import reactor.filter.PassThroughFilter;
import reactor.function.Consumer;
import reactor.function.Function;
import reactor.function.Supplier;
import reactor.function.support.SingleUseConsumer;
import reactor.tuple.Tuple2;
import reactor.util.Assert;
import reactor.util.UUIDUtils;

public class Reactor
implements Observable,
Linkable<Observable> {
    private static final EventRouter DEFAULT_EVENT_ROUTER = new ConsumerFilteringEventRouter(new PassThroughFilter(), new ArgumentConvertingConsumerInvoker(null));
    private final Dispatcher dispatcher;
    private final Registry<Consumer<? extends Event<?>>> consumerRegistry;
    private final EventRouter eventRouter;
    private final Object defaultKey = new Object();
    private final Selector defaultSelector = Selectors.$(this.defaultKey);
    private final UUID id = UUIDUtils.create();
    private final Consumer<Throwable> errorHandler = new Consumer<Throwable>(){

        @Override
        public void accept(Throwable t) {
            Reactor.this.dispatcher.dispatch(t.getClass(), Event.wrap(t).setKey(t.getClass()), Reactor.this.consumerRegistry, null, Reactor.this.eventRouter, null);
        }
    };
    private final Set<Observable> linkedReactors = Collections.synchronizedSet(new HashSet());

    public Reactor(Dispatcher dispatcher) {
        this(dispatcher, null);
    }

    public Reactor(Dispatcher dispatcher, EventRouter eventRouter) {
        this.dispatcher = dispatcher == null ? new SynchronousDispatcher() : dispatcher;
        this.eventRouter = eventRouter == null ? DEFAULT_EVENT_ROUTER : eventRouter;
        this.consumerRegistry = new CachingRegistry();
        this.on(new Consumer<Event>(){

            @Override
            public void accept(Event event) {
                if (Tuple2.class.isInstance(event.getData())) {
                    Object consumer = ((Tuple2)event.getData()).getT1();
                    Object data = ((Tuple2)event.getData()).getT2();
                    if (Consumer.class.isInstance(consumer)) {
                        try {
                            ((Consumer)consumer).accept(data);
                        }
                        catch (Throwable t) {
                            Reactor.this.notify((Object)t.getClass(), Event.wrap(t));
                        }
                    }
                }
            }
        });
        if (LoggerFactory.getLogger(Reactor.class).isDebugEnabled()) {
            this.on(new ClassSelector(Throwable.class), new Consumer<Event<Throwable>>(){
                Logger log;

                @Override
                public void accept(Event<Throwable> ev) {
                    if (null == this.log) {
                        this.log = LoggerFactory.getLogger(Reactor.class);
                    }
                    this.log.error(ev.getData().getMessage(), ev.getData());
                }
            });
        }
    }

    public UUID getId() {
        return this.id;
    }

    public Registry<Consumer<? extends Event<?>>> getConsumerRegistry() {
        return this.consumerRegistry;
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public EventRouter getEventRouter() {
        return this.eventRouter;
    }

    @Override
    public boolean respondsToKey(Object key) {
        Assert.notNull(key, "Key cannot be null.");
        return this.consumerRegistry.select(key).iterator().hasNext();
    }

    @Override
    public <E extends Event<?>> Registration<Consumer<E>> on(Selector selector, Consumer<E> consumer) {
        Assert.notNull(selector, "Selector cannot be null.");
        Assert.notNull(consumer, "Consumer cannot be null.");
        Registration<Consumer<E>> reg = this.consumerRegistry.register(selector, consumer);
        return reg;
    }

    @Override
    public <E extends Event<?>> Registration<Consumer<E>> on(Consumer<E> consumer) {
        Assert.notNull(consumer, "Consumer cannot be null.");
        return this.on(this.defaultSelector, consumer);
    }

    @Override
    public <E extends Event<?>, V> Registration<Consumer<E>> receive(Selector sel, Function<E, V> fn) {
        return this.on(sel, new ReplyToConsumer(fn));
    }

    @Override
    public <E extends Event<?>> Reactor notify(Object key, E ev, Consumer<E> onComplete) {
        Assert.notNull(key, "Key cannot be null.");
        Assert.notNull(ev, "Event cannot be null.");
        this.dispatcher.dispatch(key, ev.setKey(key), this.consumerRegistry, this.errorHandler, this.eventRouter, onComplete);
        if (!this.linkedReactors.isEmpty()) {
            for (Observable r : this.linkedReactors) {
                r.notify(key, ev);
            }
        }
        return this;
    }

    @Override
    public <E extends Event<?>> Reactor notify(Object key, E ev) {
        return this.notify(key, (Event)ev, (Consumer)null);
    }

    @Override
    public <S extends Supplier<? extends Event<?>>> Reactor notify(Object key, S supplier) {
        return this.notify(key, supplier.get(), (Consumer)null);
    }

    @Override
    public <E extends Event<?>> Reactor notify(E ev) {
        return this.notify(this.defaultKey, (Event)ev, (Consumer)null);
    }

    @Override
    public <S extends Supplier<? extends Event<?>>> Reactor notify(S supplier) {
        return this.notify(this.defaultKey, supplier.get(), (Consumer)null);
    }

    @Override
    public Reactor notify(Object key) {
        return this.notify(key, new Event<Object>(null), (Consumer)null);
    }

    @Override
    public <E extends Event<?>> Reactor send(Object key, E ev) {
        return this.notify(key, new ReplyToEvent(ev, this));
    }

    @Override
    public <S extends Supplier<? extends Event<?>>> Reactor send(Object key, S supplier) {
        return this.notify(key, new ReplyToEvent(supplier.get(), this));
    }

    @Override
    public <E extends Event<?>> Reactor send(Object key, E ev, Observable replyTo) {
        return this.notify(key, new ReplyToEvent(ev, replyTo));
    }

    @Override
    public <S extends Supplier<? extends Event<?>>> Reactor send(Object key, S supplier, Observable replyTo) {
        return this.notify(key, new ReplyToEvent(supplier.get(), replyTo));
    }

    @Override
    public <E extends Event<?>> Reactor sendAndReceive(Object key, E ev, Consumer<E> reply) {
        Tuple2<Selector, Object> anon = Selectors.anonymous();
        this.on((Selector)anon.getT1(), new SingleUseConsumer<E>(reply)).cancelAfterUse();
        this.notify(key, ev.setReplyTo(anon.getT2()));
        return this;
    }

    @Override
    public <E extends Event<?>, S extends Supplier<E>> Reactor sendAndReceive(Object key, S supplier, Consumer<E> reply) {
        return this.sendAndReceive(key, (Event)supplier.get(), (Consumer)reply);
    }

    @Override
    public <T> Consumer<Event<T>> prepare(final Object key) {
        return new Consumer<Event<T>>(){
            final List<Registration<? extends Consumer<? extends Event<?>>>> regs;
            final int size;
            {
                this.regs = Reactor.this.consumerRegistry.select(key);
                this.size = this.regs.size();
            }

            @Override
            public void accept(Event<T> ev) {
                for (int i = 0; i < this.size; ++i) {
                    Registration<Consumer<Event<?>>> reg = this.regs.get(i);
                    Reactor.this.dispatcher.dispatch(ev.setKey(key), Reactor.this.eventRouter, reg.getObject(), Reactor.this.errorHandler);
                }
            }
        };
    }

    public Reactor link(Observable reactor) {
        this.linkedReactors.add(reactor);
        return this;
    }

    public Reactor unlink(Observable reactor) {
        this.linkedReactors.remove(reactor);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Reactor reactor = (Reactor)o;
        return this.id.equals(reactor.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public class ReplyToConsumer<E extends Event<?>, V>
    implements Consumer<E> {
        private final Function<E, V> fn;

        private ReplyToConsumer(Function<E, V> fn) {
            this.fn = fn;
        }

        @Override
        public void accept(E ev) {
            Observable o;
            Observable replyToObservable = Reactor.this;
            if (ReplyToEvent.class.isAssignableFrom(ev.getClass()) && null != (o = ((ReplyToEvent)ev).getReplyToObservable())) {
                replyToObservable = o;
            }
            try {
                V reply = this.fn.apply(ev);
                Event<Object> replyEv = null == reply ? new Event<Object>(null) : (Event.class.isAssignableFrom(reply.getClass()) ? (Event<V>)reply : Event.wrap(reply));
                replyToObservable.notify(((Event)ev).getReplyTo(), replyEv);
            }
            catch (Throwable x) {
                replyToObservable.notify((Object)x.getClass(), Event.wrap(x));
            }
        }

        public Function<E, V> getDelegate() {
            return this.fn;
        }
    }

    public static class ReplyToEvent<T>
    extends Event<T> {
        private static final long serialVersionUID = 1937884784799135647L;
        private final Observable replyToObservable;

        @Override
        public <X> Event<X> copy(X data) {
            return new ReplyToEvent<X>(this.getHeaders(), data, this.getReplyTo(), this.replyToObservable, this.getErrorConsumer());
        }

        private ReplyToEvent(Event.Headers headers, T data, Object replyTo, Observable replyToObservable, Consumer<Throwable> errorConsumer) {
            super(headers, data, errorConsumer);
            this.setReplyTo(replyTo);
            this.replyToObservable = replyToObservable;
        }

        private ReplyToEvent(Event<T> delegate, Observable replyToObservable) {
            this(delegate.getHeaders(), delegate.getData(), delegate.getReplyTo(), replyToObservable, delegate.getErrorConsumer());
        }

        public Observable getReplyToObservable() {
            return this.replyToObservable;
        }
    }
}

