/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import java.io.Serializable;
import java.util.Comparator;
import org.locationtech.jts.util.Assert;
import org.locationtech.jts.util.NumberUtil;

public class Coordinate
implements Comparable<Coordinate>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 6683108902428366910L;
    public static final double NULL_ORDINATE = Double.NaN;
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    public static final int M = 3;
    public double x;
    public double y;
    public double z;

    public Coordinate(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Coordinate() {
        this(0.0, 0.0);
    }

    public Coordinate(Coordinate c) {
        this(c.x, c.y, c.getZ());
    }

    public Coordinate(double x, double y) {
        this(x, y, Double.NaN);
    }

    public void setCoordinate(Coordinate other) {
        this.x = other.x;
        this.y = other.y;
        this.z = other.getZ();
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getZ() {
        return this.z;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public double getM() {
        return Double.NaN;
    }

    public void setM(double m) {
        throw new IllegalArgumentException("Invalid ordinate index: 3");
    }

    public double getOrdinate(int ordinateIndex) {
        switch (ordinateIndex) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.getZ();
            }
        }
        throw new IllegalArgumentException("Invalid ordinate index: " + ordinateIndex);
    }

    public void setOrdinate(int ordinateIndex, double value) {
        switch (ordinateIndex) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            case 2: {
                this.setZ(value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid ordinate index: " + ordinateIndex);
            }
        }
    }

    public boolean equals2D(Coordinate other) {
        if (this.x != other.x) {
            return false;
        }
        return this.y == other.y;
    }

    public boolean equals2D(Coordinate c, double tolerance) {
        if (!NumberUtil.equalsWithTolerance(this.x, c.x, tolerance)) {
            return false;
        }
        return NumberUtil.equalsWithTolerance(this.y, c.y, tolerance);
    }

    public boolean equals3D(Coordinate other) {
        return this.x == other.x && this.y == other.y && (this.getZ() == other.getZ() || Double.isNaN(this.getZ()) && Double.isNaN(other.getZ()));
    }

    public boolean equalInZ(Coordinate c, double tolerance) {
        return NumberUtil.equalsWithTolerance(this.getZ(), c.getZ(), tolerance);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Coordinate)) {
            return false;
        }
        return this.equals2D((Coordinate)other);
    }

    @Override
    public int compareTo(Coordinate o) {
        Coordinate other = o;
        if (this.x < other.x) {
            return -1;
        }
        if (this.x > other.x) {
            return 1;
        }
        if (this.y < other.y) {
            return -1;
        }
        if (this.y > other.y) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.getZ() + ")";
    }

    public Object clone() {
        try {
            Coordinate coord = (Coordinate)super.clone();
            return coord;
        }
        catch (CloneNotSupportedException e) {
            Assert.shouldNeverReachHere("this shouldn't happen because this class is Cloneable");
            return null;
        }
    }

    public Coordinate copy() {
        return new Coordinate(this);
    }

    public double distance(Coordinate c) {
        double dx = this.x - c.x;
        double dy = this.y - c.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double distance3D(Coordinate c) {
        double dx = this.x - c.x;
        double dy = this.y - c.y;
        double dz = this.getZ() - c.getZ();
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public int hashCode() {
        int result2 = 17;
        result2 = 37 * result2 + Coordinate.hashCode(this.x);
        result2 = 37 * result2 + Coordinate.hashCode(this.y);
        return result2;
    }

    public static int hashCode(double x) {
        long f = Double.doubleToLongBits(x);
        return (int)(f ^ f >>> 32);
    }

    public static class DimensionalComparator
    implements Comparator<Coordinate> {
        private int dimensionsToTest = 2;

        public static int compare(double a, double b) {
            if (a < b) {
                return -1;
            }
            if (a > b) {
                return 1;
            }
            if (Double.isNaN(a)) {
                if (Double.isNaN(b)) {
                    return 0;
                }
                return -1;
            }
            if (Double.isNaN(b)) {
                return 1;
            }
            return 0;
        }

        public DimensionalComparator() {
            this(2);
        }

        public DimensionalComparator(int dimensionsToTest) {
            if (dimensionsToTest != 2 && dimensionsToTest != 3) {
                throw new IllegalArgumentException("only 2 or 3 dimensions may be specified");
            }
            this.dimensionsToTest = dimensionsToTest;
        }

        @Override
        public int compare(Coordinate c1, Coordinate c2) {
            int compX = DimensionalComparator.compare(c1.x, c2.x);
            if (compX != 0) {
                return compX;
            }
            int compY = DimensionalComparator.compare(c1.y, c2.y);
            if (compY != 0) {
                return compY;
            }
            if (this.dimensionsToTest <= 2) {
                return 0;
            }
            int compZ = DimensionalComparator.compare(c1.getZ(), c2.getZ());
            return compZ;
        }
    }
}

