/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.io;

import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sedona_sql.io.GeotiffSchema$;
import org.apache.spark.sql.sedona_sql.io.ImageOptions;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Ub!\u0002\u0004\b\u00015\u0019\u0002\"\u0002\u0015\u0001\t\u0003Q\u0003\"B\u0017\u0001\t\u0003r\u0003\"B1\u0001\t\u0003\u0012\u0007\"\u0002:\u0001\t\u0003\u001a\b\"\u0002;\u0001\t#*(!E$f_RLgM\u001a$jY\u00164uN]7bi*\u0011\u0001\"C\u0001\u0003S>T!AC\u0006\u0002\u0015M,Gm\u001c8b?N\fHN\u0003\u0002\r\u001b\u0005\u00191/\u001d7\u000b\u00059y\u0011!B:qCJ\\'B\u0001\t\u0012\u0003\u0019\t\u0007/Y2iK*\t!#A\u0002pe\u001e\u001cB\u0001\u0001\u000b\u001bEA\u0011Q\u0003G\u0007\u0002-)\tq#A\u0003tG\u0006d\u0017-\u0003\u0002\u001a-\t1\u0011I\\=SK\u001a\u0004\"a\u0007\u0011\u000e\u0003qQ!!\b\u0010\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0003?-\t\u0011\"\u001a=fGV$\u0018n\u001c8\n\u0005\u0005b\"A\u0003$jY\u00164uN]7biB\u00111EJ\u0007\u0002I)\u0011QeC\u0001\bg>,(oY3t\u0013\t9CE\u0001\nECR\f7k\\;sG\u0016\u0014VmZ5ti\u0016\u0014\u0018A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003-\u0002\"\u0001\f\u0001\u000e\u0003\u001d\t1\"\u001b8gKJ\u001c6\r[3nCR!q\u0006\u000f O!\r)\u0002GM\u0005\u0003cY\u0011aa\u00149uS>t\u0007CA\u001a7\u001b\u0005!$BA\u001b\f\u0003\u0015!\u0018\u0010]3t\u0013\t9DG\u0001\u0006TiJ,8\r\u001e+za\u0016DQ!\u000f\u0002A\u0002i\nAb\u001d9be.\u001cVm]:j_:\u0004\"a\u000f\u001f\u000e\u0003-I!!P\u0006\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\t\u000b}\u0012\u0001\u0019\u0001!\u0002\u000f=\u0004H/[8ogB!\u0011\tS&L\u001d\t\u0011e\t\u0005\u0002D-5\tAI\u0003\u0002FS\u00051AH]8pizJ!a\u0012\f\u0002\rA\u0013X\rZ3g\u0013\tI%JA\u0002NCBT!a\u0012\f\u0011\u0005\u0005c\u0015BA'K\u0005\u0019\u0019FO]5oO\")qJ\u0001a\u0001!\u0006)a-\u001b7fgB\u0019\u0011KV-\u000f\u0005I#fBA\"T\u0013\u00059\u0012BA+\u0017\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0016-\u0003\u0007M+\u0017O\u0003\u0002V-A\u0011!lX\u0007\u00027*\u0011A,X\u0001\u0003MNT!AX\b\u0002\r!\fGm\\8q\u0013\t\u00017L\u0001\u0006GS2,7\u000b^1ukN\fA\u0002\u001d:fa\u0006\u0014Xm\u0016:ji\u0016$Ra\u00194h_B\u0004\"a\u00073\n\u0005\u0015d\"aE(viB,Ho\u0016:ji\u0016\u0014h)Y2u_JL\b\"B\u001d\u0004\u0001\u0004Q\u0004\"\u00025\u0004\u0001\u0004I\u0017a\u00016pEB\u0011!.\\\u0007\u0002W*\u0011A.X\u0001\n[\u0006\u0004(/\u001a3vG\u0016L!A\\6\u0003\u0007){'\rC\u0003@\u0007\u0001\u0007\u0001\tC\u0003r\u0007\u0001\u0007!'\u0001\u0006eCR\f7k\u00195f[\u0006\f\u0011b\u001d5peRt\u0015-\\3\u0015\u0003-\u000b1BY;jY\u0012\u0014V-\u00193feRya/a\u0003\u0002\u000e\u0005=\u00111CA\f\u0003G\t)\u0003\u0005\u0003\u0016ofd\u0018B\u0001=\u0017\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002\u001cu&\u00111\u0010\b\u0002\u0010!\u0006\u0014H/\u001b;j_:,GMR5mKB\u0019\u0011+`@\n\u0005yD&\u0001C%uKJ\fGo\u001c:\u0011\t\u0005\u0005\u0011qA\u0007\u0003\u0003\u0007Q1!!\u0002\f\u0003!\u0019\u0017\r^1msN$\u0018\u0002BA\u0005\u0003\u0007\u00111\"\u00138uKJt\u0017\r\u001c*po\")\u0011(\u0002a\u0001u!)\u0011/\u0002a\u0001e!1\u0011\u0011C\u0003A\u0002I\nq\u0002]1si&$\u0018n\u001c8TG\",W.\u0019\u0005\u0007\u0003+)\u0001\u0019\u0001\u001a\u0002\u001dI,\u0017/^5sK\u0012\u001c6\r[3nC\"9\u0011\u0011D\u0003A\u0002\u0005m\u0011a\u00024jYR,'o\u001d\t\u0005#Z\u000bi\u0002E\u0002$\u0003?I1!!\t%\u0005\u00191\u0015\u000e\u001c;fe\")q(\u0002a\u0001\u0001\"9\u0011qE\u0003A\u0002\u0005%\u0012A\u00035bI>|\u0007oQ8oMB!\u00111FA\u0019\u001b\t\tiCC\u0002\u00020u\u000bAaY8oM&!\u00111GA\u0017\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u0002")
public class GeotiffFileFormat
implements FileFormat,
DataSourceRegister {
    public boolean supportBatch(SparkSession sparkSession, StructType dataSchema) {
        return FileFormat.supportBatch$((FileFormat)this, (SparkSession)sparkSession, (StructType)dataSchema);
    }

    public Option<Seq<String>> vectorTypes(StructType requiredSchema, StructType partitionSchema, SQLConf sqlConf) {
        return FileFormat.vectorTypes$((FileFormat)this, (StructType)requiredSchema, (StructType)partitionSchema, (SQLConf)sqlConf);
    }

    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        return FileFormat.isSplitable$((FileFormat)this, (SparkSession)sparkSession, options, (Path)path);
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        return FileFormat.buildReaderWithPartitionValues$((FileFormat)this, (SparkSession)sparkSession, (StructType)dataSchema, (StructType)partitionSchema, (StructType)requiredSchema, filters, options, (Configuration)hadoopConf);
    }

    public boolean supportDataType(DataType dataType, boolean isReadPath) {
        return FileFormat.supportDataType$((FileFormat)this, (DataType)dataType, (boolean)isReadPath);
    }

    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        return new Some((Object)GeotiffSchema$.MODULE$.imageSchema());
    }

    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        throw new UnsupportedOperationException("Write is not supported for image data source");
    }

    public String shortName() {
        return "geotiff";
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        Predef$.MODULE$.assert(requiredSchema.length() <= 1, (Function0 & Serializable & scala.Serializable)() -> "Image data source only produces a single data column named \"image\".");
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        ImageOptions imageSourceOptions = new ImageOptions(options);
        return (Function1 & Serializable & scala.Serializable)file -> {
            Iterator iterator;
            UnsafeRow emptyUnsafeRow = new UnsafeRow(0);
            if (!imageSourceOptions.dropInvalid() && requiredSchema.isEmpty()) {
                iterator = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnsafeRow[]{emptyUnsafeRow}));
            } else {
                Iterator filteredResult;
                byte[] byArray;
                String origin = file.filePath();
                Path path = new Path(origin);
                FileSystem fs = path.getFileSystem(((SerializableConfiguration)broadcastedHadoopConf.value()).value());
                FSDataInputStream stream = fs.open(path);
                try {
                    byArray = ByteStreams.toByteArray((InputStream)stream);
                }
                finally {
                    Closeables.close((Closeable)stream, (boolean)true);
                }
                byte[] bytes = byArray;
                Option<Row> resultOpt = GeotiffSchema$.MODULE$.decode(origin, bytes);
                Iterator iterator2 = filteredResult = imageSourceOptions.dropInvalid() ? Option$.MODULE$.option2Iterable(resultOpt).toIterator() : package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{(Row)resultOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> GeotiffSchema$.MODULE$.invalidImageRow(origin))}));
                if (requiredSchema.isEmpty()) {
                    iterator = filteredResult.map((Function1 & Serializable & scala.Serializable)x$1 -> emptyUnsafeRow);
                } else {
                    ExpressionEncoder converter = RowEncoder$.MODULE$.apply(requiredSchema);
                    iterator = filteredResult.map((Function1 & Serializable & scala.Serializable)row -> converter.toRow(row));
                }
            }
            return iterator;
        };
    }

    public GeotiffFileFormat() {
        FileFormat.$init$((FileFormat)this);
    }
}

