/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.flink.expressions;

import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.sedona.core.enums.FileDataSplitter;
import org.apache.sedona.core.enums.GeometryType;
import org.apache.sedona.core.formatMapper.FormatUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.ParseException;

public class Constructors {

    public static class ST_GeomFromGeoJSON
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String geoJson) throws ParseException {
            FormatUtils formatUtils = new FormatUtils(FileDataSplitter.GEOJSON, false);
            return formatUtils.readGeometry(geoJson);
        }
    }

    public static class ST_GeomFromWKB
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String wkbString) throws ParseException {
            FormatUtils formatUtils = new FormatUtils(FileDataSplitter.WKB, false);
            return formatUtils.readGeometry(wkbString);
        }
    }

    public static class ST_GeomFromWKT
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String wktString) throws ParseException {
            FormatUtils formatUtils = new FormatUtils(FileDataSplitter.WKT, false);
            return formatUtils.readGeometry(wktString);
        }
    }

    public static class ST_PolygonFromEnvelope
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="Double") Double minX, @DataTypeHint(value="Double") Double minY, @DataTypeHint(value="Double") Double maxX, @DataTypeHint(value="Double") Double maxY) {
            Coordinate[] coordinates;
            coordinates = new Coordinate[]{new Coordinate(minX.doubleValue(), minY.doubleValue()), new Coordinate(minX.doubleValue(), maxY.doubleValue()), new Coordinate(maxX.doubleValue(), maxY.doubleValue()), new Coordinate(maxX.doubleValue(), minY.doubleValue()), coordinates[0]};
            GeometryFactory geometryFactory = new GeometryFactory();
            return geometryFactory.createPolygon(coordinates);
        }
    }

    public static class ST_PolygonFromText
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String s, @DataTypeHint(value="String") String inputDelimiter) throws ParseException {
            FileDataSplitter delimiter = inputDelimiter == null ? FileDataSplitter.CSV : FileDataSplitter.getFileDataSplitter((String)inputDelimiter);
            FormatUtils formatUtils = new FormatUtils(delimiter, false, GeometryType.POLYGON);
            return formatUtils.readGeometry(s);
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String s) throws ParseException {
            return this.eval(s, null);
        }
    }

    public static class ST_PointFromText
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String s, @DataTypeHint(value="String") String inputDelimiter) throws ParseException {
            FileDataSplitter delimiter = inputDelimiter == null ? FileDataSplitter.CSV : FileDataSplitter.getFileDataSplitter((String)inputDelimiter);
            FormatUtils formatUtils = new FormatUtils(delimiter, false, GeometryType.POINT);
            return formatUtils.readGeometry(s);
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String s) throws ParseException {
            return this.eval(s, null);
        }
    }
}

