/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.spatialRDD;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.sedona.core.enums.FileDataSplitter;
import org.apache.sedona.core.formatMapper.FormatMapper;
import org.apache.sedona.core.formatMapper.PolygonFormatMapper;
import org.apache.sedona.core.spatialRDD.SpatialRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.storage.StorageLevel;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.precision.GeometryPrecisionReducer;

public class PolygonRDD
extends SpatialRDD<Polygon> {
    public PolygonRDD() {
    }

    public PolygonRDD(JavaRDD<Polygon> rawSpatialRDD) {
        this.rawSpatialRDD = rawSpatialRDD;
    }

    public PolygonRDD(JavaRDD<Polygon> rawSpatialRDD, String sourceEpsgCRSCode, String targetEpsgCode) {
        this.rawSpatialRDD = rawSpatialRDD;
        this.CRSTransform(sourceEpsgCRSCode, targetEpsgCode);
    }

    public PolygonRDD(JavaSparkContext sparkContext, String InputLocation, Integer startOffset, Integer endOffset, FileDataSplitter splitter2, boolean carryInputData, Integer partitions) {
        this(sparkContext, InputLocation, startOffset, endOffset, splitter2, carryInputData, partitions, null, null, null);
    }

    public PolygonRDD(JavaSparkContext sparkContext, String InputLocation, Integer startOffset, Integer endOffset, FileDataSplitter splitter2, boolean carryInputData) {
        this(sparkContext, InputLocation, startOffset, endOffset, splitter2, carryInputData, null, null, null, null);
    }

    public PolygonRDD(JavaSparkContext sparkContext, String InputLocation, FileDataSplitter splitter2, boolean carryInputData, Integer partitions) {
        this(sparkContext, InputLocation, null, null, splitter2, carryInputData, partitions, null, null, null);
    }

    public PolygonRDD(JavaSparkContext sparkContext, String InputLocation, FileDataSplitter splitter2, boolean carryInputData) {
        this(sparkContext, InputLocation, null, null, splitter2, carryInputData, null, null, null, null);
    }

    public PolygonRDD(JavaSparkContext sparkContext, String InputLocation, Integer partitions, FlatMapFunction userSuppliedMapper) {
        this.setRawSpatialRDD(sparkContext.textFile(InputLocation, partitions.intValue()).mapPartitions(userSuppliedMapper));
    }

    public PolygonRDD(JavaSparkContext sparkContext, String InputLocation, FlatMapFunction userSuppliedMapper) {
        this.setRawSpatialRDD(sparkContext.textFile(InputLocation).mapPartitions(userSuppliedMapper));
    }

    public PolygonRDD(JavaRDD<Polygon> rawSpatialRDD, Envelope datasetBoundary, Integer approximateTotalCount) {
        this.rawSpatialRDD = rawSpatialRDD;
        this.boundaryEnvelope = datasetBoundary;
        this.approximateTotalCount = approximateTotalCount.intValue();
    }

    public PolygonRDD(JavaRDD<Polygon> rawSpatialRDD, String sourceEpsgCRSCode, String targetEpsgCode, Envelope datasetBoundary, Integer approximateTotalCount) {
        this.rawSpatialRDD = rawSpatialRDD;
        this.CRSTransform(sourceEpsgCRSCode, targetEpsgCode);
        this.boundaryEnvelope = datasetBoundary;
        this.approximateTotalCount = approximateTotalCount.intValue();
    }

    public PolygonRDD(JavaSparkContext sparkContext, String InputLocation, Integer startOffset, Integer endOffset, FileDataSplitter splitter2, boolean carryInputData, Integer partitions, Envelope datasetBoundary, Integer approximateTotalCount) {
        this(sparkContext, InputLocation, startOffset, endOffset, splitter2, carryInputData, partitions, null, null, null);
    }

    public PolygonRDD(JavaSparkContext sparkContext, String InputLocation, Integer startOffset, Integer endOffset, FileDataSplitter splitter2, boolean carryInputData, Envelope datasetBoundary, Integer approximateTotalCount) {
        this(sparkContext, InputLocation, startOffset, endOffset, splitter2, carryInputData, null, null, null, null);
    }

    public PolygonRDD(JavaSparkContext sparkContext, String InputLocation, FileDataSplitter splitter2, boolean carryInputData, Integer partitions, Envelope datasetBoundary, Integer approximateTotalCount) {
        this(sparkContext, InputLocation, null, null, splitter2, carryInputData, partitions, null, null, null);
    }

    public PolygonRDD(JavaSparkContext sparkContext, String InputLocation, FileDataSplitter splitter2, boolean carryInputData, Envelope datasetBoundary, Integer approximateTotalCount) {
        this(sparkContext, InputLocation, null, null, splitter2, carryInputData, null, null, null, null);
    }

    public PolygonRDD(JavaSparkContext sparkContext, String InputLocation, Integer partitions, FlatMapFunction userSuppliedMapper, Envelope datasetBoundary, Integer approximateTotalCount) {
        this.setRawSpatialRDD(sparkContext.textFile(InputLocation, partitions.intValue()).mapPartitions(userSuppliedMapper));
        this.boundaryEnvelope = datasetBoundary;
        this.approximateTotalCount = approximateTotalCount.intValue();
    }

    public PolygonRDD(JavaSparkContext sparkContext, String InputLocation, FlatMapFunction userSuppliedMapper, Envelope datasetBoundary, Integer approximateTotalCount) {
        this.setRawSpatialRDD(sparkContext.textFile(InputLocation).mapPartitions(userSuppliedMapper));
        this.boundaryEnvelope = datasetBoundary;
        this.approximateTotalCount = approximateTotalCount.intValue();
    }

    public PolygonRDD(JavaRDD<Polygon> rawSpatialRDD, StorageLevel newLevel) {
        this.rawSpatialRDD = rawSpatialRDD;
        this.analyze(newLevel);
    }

    public PolygonRDD(JavaSparkContext sparkContext, String InputLocation, Integer startOffset, Integer endOffset, FileDataSplitter splitter2, boolean carryInputData, Integer partitions, StorageLevel newLevel) {
        this(sparkContext, InputLocation, startOffset, endOffset, splitter2, carryInputData, partitions, newLevel, null, null);
    }

    public PolygonRDD(JavaSparkContext sparkContext, String InputLocation, Integer startOffset, Integer endOffset, FileDataSplitter splitter2, boolean carryInputData, StorageLevel newLevel) {
        this(sparkContext, InputLocation, startOffset, endOffset, splitter2, carryInputData, null, newLevel, null, null);
    }

    public PolygonRDD(JavaSparkContext sparkContext, String InputLocation, FileDataSplitter splitter2, boolean carryInputData, Integer partitions, StorageLevel newLevel) {
        this(sparkContext, InputLocation, null, null, splitter2, carryInputData, partitions, newLevel, null, null);
    }

    public PolygonRDD(JavaSparkContext sparkContext, String InputLocation, FileDataSplitter splitter2, boolean carryInputData, StorageLevel newLevel) {
        this(sparkContext, InputLocation, null, null, splitter2, carryInputData, null, newLevel, null, null);
    }

    public PolygonRDD(JavaSparkContext sparkContext, String InputLocation, Integer partitions, FlatMapFunction userSuppliedMapper, StorageLevel newLevel) {
        this.setRawSpatialRDD(sparkContext.textFile(InputLocation, partitions.intValue()).mapPartitions(userSuppliedMapper));
        this.analyze(newLevel);
    }

    public PolygonRDD(JavaSparkContext sparkContext, String InputLocation, FlatMapFunction userSuppliedMapper, StorageLevel newLevel) {
        this.setRawSpatialRDD(sparkContext.textFile(InputLocation).mapPartitions(userSuppliedMapper));
        this.analyze(newLevel);
    }

    public PolygonRDD(JavaRDD<Polygon> rawSpatialRDD, StorageLevel newLevel, String sourceEpsgCRSCode, String targetEpsgCode) {
        this.rawSpatialRDD = rawSpatialRDD;
        this.CRSTransform(sourceEpsgCRSCode, targetEpsgCode);
        this.analyze(newLevel);
    }

    public PolygonRDD(JavaSparkContext sparkContext, String InputLocation, Integer startOffset, Integer endOffset, FileDataSplitter splitter2, boolean carryInputData, Integer partitions, StorageLevel newLevel, String sourceEpsgCRSCode, String targetEpsgCode) {
        JavaRDD rawTextRDD;
        JavaRDD javaRDD = rawTextRDD = partitions != null ? sparkContext.textFile(InputLocation, partitions.intValue()) : sparkContext.textFile(InputLocation);
        if (startOffset != null && endOffset != null) {
            this.setRawSpatialRDD(rawTextRDD.mapPartitions((FlatMapFunction)new PolygonFormatMapper(startOffset, endOffset, splitter2, carryInputData)));
        } else {
            this.setRawSpatialRDD(rawTextRDD.mapPartitions((FlatMapFunction)new PolygonFormatMapper(splitter2, carryInputData)));
        }
        if (sourceEpsgCRSCode != null && targetEpsgCode != null) {
            this.CRSTransform(sourceEpsgCRSCode, targetEpsgCode);
        }
        if (newLevel != null) {
            this.analyze(newLevel);
        }
        if (splitter2.equals(FileDataSplitter.GEOJSON)) {
            this.fieldNames = FormatMapper.readGeoJsonPropertyNames(rawTextRDD.take(1).get(0).toString());
        }
    }

    public PolygonRDD(JavaSparkContext sparkContext, String InputLocation, Integer startOffset, Integer endOffset, FileDataSplitter splitter2, boolean carryInputData, StorageLevel newLevel, String sourceEpsgCRSCode, String targetEpsgCode) {
        this(sparkContext, InputLocation, startOffset, endOffset, splitter2, carryInputData, null, newLevel, sourceEpsgCRSCode, targetEpsgCode);
    }

    public PolygonRDD(JavaSparkContext sparkContext, String InputLocation, FileDataSplitter splitter2, boolean carryInputData, Integer partitions, StorageLevel newLevel, String sourceEpsgCRSCode, String targetEpsgCode) {
        this(sparkContext, InputLocation, null, null, splitter2, carryInputData, partitions, newLevel, sourceEpsgCRSCode, targetEpsgCode);
    }

    public PolygonRDD(JavaSparkContext sparkContext, String InputLocation, FileDataSplitter splitter2, boolean carryInputData, StorageLevel newLevel, String sourceEpsgCRSCode, String targetEpsgCode) {
        this(sparkContext, InputLocation, null, null, splitter2, carryInputData, null, newLevel, sourceEpsgCRSCode, targetEpsgCode);
    }

    public PolygonRDD(JavaSparkContext sparkContext, String InputLocation, Integer partitions, FlatMapFunction userSuppliedMapper, StorageLevel newLevel, String sourceEpsgCRSCode, String targetEpsgCode) {
        this.setRawSpatialRDD(sparkContext.textFile(InputLocation, partitions.intValue()).mapPartitions(userSuppliedMapper));
        this.CRSTransform(sourceEpsgCRSCode, targetEpsgCode);
        this.analyze(newLevel);
    }

    public PolygonRDD(JavaSparkContext sparkContext, String InputLocation, FlatMapFunction userSuppliedMapper, StorageLevel newLevel, String sourceEpsgCRSCode, String targetEpsgCode) {
        this.setRawSpatialRDD(sparkContext.textFile(InputLocation).mapPartitions(userSuppliedMapper));
        this.CRSTransform(sourceEpsgCRSCode, targetEpsgCode);
        this.analyze(newLevel);
    }

    public Polygon PolygonUnion() {
        Polygon result2 = (Polygon)this.rawSpatialRDD.reduce((Function2)new Function2<Polygon, Polygon, Polygon>(){

            public Polygon call(Polygon v1, Polygon v2) {
                PrecisionModel pModel = new PrecisionModel();
                GeometryPrecisionReducer pReducer = new GeometryPrecisionReducer(pModel);
                Geometry p1 = pReducer.reduce((Geometry)v1);
                Geometry p2 = pReducer.reduce((Geometry)v2);
                Geometry polygonGeom = p1.union(p2);
                Coordinate[] coordinates = polygonGeom.getCoordinates();
                ArrayList<Coordinate> coordinateList = new ArrayList<Coordinate>(Arrays.asList(coordinates));
                Coordinate lastCoordinate = coordinateList.get(0);
                coordinateList.add(lastCoordinate);
                Coordinate[] coordinatesClosed = new Coordinate[coordinateList.size()];
                coordinatesClosed = coordinateList.toArray(coordinatesClosed);
                GeometryFactory fact = new GeometryFactory();
                LinearRing linear = new GeometryFactory().createLinearRing(coordinatesClosed);
                Polygon polygon = new Polygon(linear, null, fact);
                return polygon;
            }
        });
        return result2;
    }
}

