/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.formatMapper.shapefileParser.shapes;

import java.io.IOException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.shp.ShpFileParser;
import org.apache.sedona.core.formatMapper.shapefileParser.shapes.ShapeKey;
import org.apache.sedona.core.formatMapper.shapefileParser.shapes.ShpRecord;

public class ShapeFileReader
extends RecordReader<ShapeKey, ShpRecord> {
    ShpFileParser parser = null;
    private ShapeKey recordKey = null;
    private ShpRecord recordContent = null;
    private FSDataInputStream shpInputStream = null;
    private int[] indexes;
    private boolean useIndex = false;
    private int indexId = 0;

    public ShapeFileReader() {
    }

    public ShapeFileReader(int[] indexes) {
        this.indexes = indexes;
        this.useIndex = true;
    }

    public void initialize(InputSplit split2, TaskAttemptContext context) throws IOException, InterruptedException {
        FileSplit fileSplit = (FileSplit)split2;
        Path filePath = fileSplit.getPath();
        FileSystem fileSys = filePath.getFileSystem(context.getConfiguration());
        this.shpInputStream = fileSys.open(filePath);
        this.parser = new ShpFileParser(this.shpInputStream);
        this.parser.parseShapeFileHead();
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.useIndex) {
            if (this.indexId == this.indexes.length) {
                return false;
            }
            if (this.shpInputStream.getPos() < (long)(this.indexes[this.indexId] * 2)) {
                this.shpInputStream.skip((long)(this.indexes[this.indexId] * 2) - this.shpInputStream.getPos());
            }
            int currentLength = this.indexes[this.indexId + 1] * 2 - 4;
            this.recordKey = new ShapeKey();
            this.recordKey.setIndex(this.parser.parseRecordHeadID());
            this.recordContent = this.parser.parseRecordPrimitiveContent(currentLength);
            this.indexId += 2;
            return true;
        }
        if (this.getProgress() >= 1.0f) {
            return false;
        }
        this.recordKey = new ShapeKey();
        this.recordKey.setIndex(this.parser.parseRecordHeadID());
        this.recordContent = this.parser.parseRecordPrimitiveContent();
        return true;
    }

    public ShapeKey getCurrentKey() throws IOException, InterruptedException {
        return this.recordKey;
    }

    public ShpRecord getCurrentValue() throws IOException, InterruptedException {
        return this.recordContent;
    }

    public float getProgress() throws IOException, InterruptedException {
        return this.parser.getProgress();
    }

    public void close() throws IOException {
        this.shpInputStream.close();
    }
}

