/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.shp;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.commons.io.EndianUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.shp.ShapeFileConst;
import org.apache.sedona.core.formatMapper.shapefileParser.shapes.ShpRecord;

public class ShpFileParser
implements Serializable,
ShapeFileConst {
    private final SafeReader reader;
    private long fileLength = 0L;
    private long remainLength = 0L;

    public ShpFileParser(FSDataInputStream inputStream) {
        this.reader = new SafeReader(inputStream);
    }

    public void parseShapeFileHead() throws IOException {
        this.reader.skip(4);
        this.reader.skip(20);
        this.remainLength = this.fileLength = 2L * ((long)this.reader.readInt() - 50L);
        this.reader.skip(8);
        this.reader.skip(64);
    }

    public ShpRecord parseRecordPrimitiveContent() throws IOException {
        int contentLength = this.reader.readInt();
        long recordLength = 2 * (contentLength + 4);
        this.remainLength -= recordLength;
        int typeID = EndianUtils.swapInteger((int)this.reader.readInt());
        byte[] contentArray = new byte[contentLength * 2 - 4];
        this.reader.read(contentArray, 0, contentArray.length);
        return new ShpRecord(contentArray, typeID);
    }

    public ShpRecord parseRecordPrimitiveContent(int length) throws IOException {
        int contentLength = this.reader.readInt();
        long recordLength = 2 * (contentLength + 4);
        this.remainLength -= recordLength;
        int typeID = EndianUtils.swapInteger((int)this.reader.readInt());
        byte[] contentArray = new byte[length];
        this.reader.read(contentArray, 0, contentArray.length);
        return new ShpRecord(contentArray, typeID);
    }

    public int parseRecordHeadID() throws IOException {
        return this.reader.readInt();
    }

    public float getProgress() {
        return 1.0f - (float)this.remainLength / (float)this.fileLength;
    }

    private static final class SafeReader {
        private final FSDataInputStream input;

        private SafeReader(FSDataInputStream input2) {
            this.input = input2;
        }

        public int readInt() throws IOException {
            byte[] bytes = new byte[4];
            this.input.readFully(bytes);
            return ByteBuffer.wrap(bytes).getInt();
        }

        public void skip(int numBytes) throws IOException {
            this.input.skip((long)numBytes);
        }

        public void read(byte[] buffer, int offset, int length) throws IOException {
            this.input.readFully(buffer, offset, length);
        }
    }
}

