/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_viz.expressions;

import java.awt.image.BufferedImage;
import org.apache.sedona.viz.core.ImageSerializableWrapper;
import org.apache.sedona.viz.utils.Pixel;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.MutableAggregationBuffer;
import org.apache.spark.sql.expressions.UserDefinedAggregateFunction;
import org.apache.spark.sql.sedona_viz.UDT.ImageWrapperUDT;
import org.apache.spark.sql.sedona_viz.UDT.PixelUDT;
import org.apache.spark.sql.sedona_viz.expressions.ST_Render$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.Product$class;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005%d\u0001B\u0001\u0003\u0001>\u0011\u0011b\u0015+`%\u0016tG-\u001a:\u000b\u0005\r!\u0011aC3yaJ,7o]5p]NT!!\u0002\u0004\u0002\u0015M,Gm\u001c8b?ZL'P\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0003\u0001!UY\u0012\u0005\u0005\u0002\u0012'5\t!C\u0003\u0002\u0004\r%\u0011AC\u0005\u0002\u001d+N,'\u000fR3gS:,G-Q4he\u0016<\u0017\r^3Gk:\u001cG/[8o!\t1\u0012$D\u0001\u0018\u0015\tA\u0002\"\u0001\u0005j]R,'O\\1m\u0013\tQrCA\u0004M_\u001e<\u0017N\\4\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\u000fA\u0013x\u000eZ;diB\u0011ADI\u0005\u0003Gu\u0011AbU3sS\u0006d\u0017N_1cY\u0016DQ!\n\u0001\u0005\u0002\u0019\na\u0001P5oSRtD#A\u0014\u0011\u0005!\u0002Q\"\u0001\u0002\t\u000b)\u0002A\u0011I\u0016\u0002\u0017%t\u0007/\u001e;TG\",W.Y\u000b\u0002YA\u0011Q\u0006M\u0007\u0002])\u0011qFB\u0001\u0006if\u0004Xm]\u0005\u0003c9\u0012!b\u0015;sk\u000e$H+\u001f9f\u0011\u0015\u0019\u0004\u0001\"\u0011,\u00031\u0011WO\u001a4feN\u001b\u0007.Z7b\u0011\u0015)\u0004\u0001\"\u00117\u0003!!xn\u0015;sS:<G#A\u001c\u0011\u0005aZdB\u0001\u000f:\u0013\tQT$\u0001\u0004Qe\u0016$WMZ\u0005\u0003yu\u0012aa\u0015;sS:<'B\u0001\u001e\u001e\u0011\u0015y\u0004\u0001\"\u0011A\u0003!!\u0017\r^1UsB,W#A!\u0011\u00055\u0012\u0015BA\"/\u0005!!\u0015\r^1UsB,\u0007\"B#\u0001\t\u00032\u0015!\u00043fi\u0016\u0014X.\u001b8jgRL7-F\u0001H!\ta\u0002*\u0003\u0002J;\t9!i\\8mK\u0006t\u0007\"B&\u0001\t\u0003b\u0015AC5oSRL\u0017\r\\5{KR\u0011Q\n\u0015\t\u000399K!aT\u000f\u0003\tUs\u0017\u000e\u001e\u0005\u0006#*\u0003\rAU\u0001\u0007EV4g-\u001a:\u0011\u0005E\u0019\u0016B\u0001+\u0013\u0005aiU\u000f^1cY\u0016\fum\u001a:fO\u0006$\u0018n\u001c8Ck\u001a4WM\u001d\u0005\u0006-\u0002!\teV\u0001\u0007kB$\u0017\r^3\u0015\u00075C\u0016\fC\u0003R+\u0002\u0007!\u000bC\u0003[+\u0002\u00071,A\u0003j]B,H\u000f\u0005\u0002];6\ta!\u0003\u0002_\r\t\u0019!k\\<\t\u000b\u0001\u0004A\u0011I1\u0002\u000b5,'oZ3\u0015\u00075\u0013G\rC\u0003d?\u0002\u0007!+A\u0004ck\u001a4WM]\u0019\t\u000b\u0015|\u0006\u0019A.\u0002\u000f\t,hMZ3se!)q\r\u0001C!Q\u0006AQM^1mk\u0006$X\r\u0006\u0002jYB\u0011AD[\u0005\u0003Wv\u00111!\u00118z\u0011\u0015\tf\r1\u0001\\\u0011\u001dq\u0007!!A\u0005\u0002\u0019\nAaY8qs\"9\u0001\u000fAA\u0001\n\u0003\n\u0018!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070F\u0001s!\t\u0019\b0D\u0001u\u0015\t)h/\u0001\u0003mC:<'\"A<\u0002\t)\fg/Y\u0005\u0003yQDqA\u001f\u0001\u0002\u0002\u0013\u000510\u0001\u0007qe>$Wo\u0019;Be&$\u00180F\u0001}!\taR0\u0003\u0002\u007f;\t\u0019\u0011J\u001c;\t\u0013\u0005\u0005\u0001!!A\u0005\u0002\u0005\r\u0011A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004S\u0006\u0015\u0001\u0002CA\u0004\u007f\u0006\u0005\t\u0019\u0001?\u0002\u0007a$\u0013\u0007C\u0005\u0002\f\u0001\t\t\u0011\"\u0011\u0002\u000e\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\u0010A)\u0011\u0011CA\fS6\u0011\u00111\u0003\u0006\u0004\u0003+i\u0012AC2pY2,7\r^5p]&!\u0011\u0011DA\n\u0005!IE/\u001a:bi>\u0014\b\"CA\u000f\u0001\u0005\u0005I\u0011AA\u0010\u0003!\u0019\u0017M\\#rk\u0006dGcA$\u0002\"!I\u0011qAA\u000e\u0003\u0003\u0005\r!\u001b\u0005\n\u0003K\u0001\u0011\u0011!C!\u0003O\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002y\"I\u00111\u0006\u0001\u0002\u0002\u0013\u0005\u0013QF\u0001\u0007KF,\u0018\r\\:\u0015\u0007\u001d\u000by\u0003C\u0005\u0002\b\u0005%\u0012\u0011!a\u0001S\u001eI\u00111\u0007\u0002\u0002\u0002#\u0005\u0011QG\u0001\n'R{&+\u001a8eKJ\u00042\u0001KA\u001c\r!\t!!!A\t\u0002\u0005e2#BA\u001c\u0003w\t\u0003#BA\u001f\u0003\u0007:SBAA \u0015\r\t\t%H\u0001\beVtG/[7f\u0013\u0011\t)%a\u0010\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0007\u0007C\u0004&\u0003o!\t!!\u0013\u0015\u0005\u0005U\u0002\"C\u001b\u00028\u0005\u0005IQIA')\u0005\u0011\b\"CA)\u0003o\t\t\u0011\"!'\u0003\u0015\t\u0007\u000f\u001d7z\u0011)\t)&a\u000e\u0002\u0002\u0013\u0005\u0015qK\u0001\bk:\f\u0007\u000f\u001d7z)\r9\u0015\u0011\f\u0005\n\u00037\n\u0019&!AA\u0002\u001d\n1\u0001\u001f\u00131\u0011)\ty&a\u000e\u0002\u0002\u0013%\u0011\u0011M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002dA\u00191/!\u001a\n\u0007\u0005\u001dDO\u0001\u0004PE*,7\r\u001e")
public class ST_Render
extends UserDefinedAggregateFunction
implements Logging,
Product {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static boolean unapply(ST_Render sT_Render) {
        return ST_Render$.MODULE$.unapply(sT_Render);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public StructType inputSchema() {
        return new StructType().add("Pixel", (DataType)new PixelUDT()).add("Color", (DataType)IntegerType$.MODULE$).add("Zoom Level", (DataType)IntegerType$.MODULE$, true);
    }

    public StructType bufferSchema() {
        return new StructType().add("ColorArray", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false)).add("XArray", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false)).add("YArray", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false)).add("ResolutionX", (DataType)IntegerType$.MODULE$).add("ResolutionY", (DataType)IntegerType$.MODULE$);
    }

    public String toString() {
        return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{" **", "**  "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{ST_Render$.MODULE$.getClass().getName()}));
    }

    public DataType dataType() {
        return new ImageWrapperUDT();
    }

    public boolean deterministic() {
        return true;
    }

    public void initialize(MutableAggregationBuffer buffer) {
        int[] array = new int[]{};
        buffer.update(0, (Object)array);
        buffer.update(1, (Object)array);
        buffer.update(2, (Object)array);
        buffer.update(3, (Object)BoxesRunTime.boxToInteger(0));
        buffer.update(4, (Object)BoxesRunTime.boxToInteger(0));
    }

    public void update(MutableAggregationBuffer buffer, Row input2) {
        Seq colorArray = (Seq)buffer.getAs(0);
        Seq xArray = (Seq)buffer.getAs(1);
        Seq yArray = (Seq)buffer.getAs(2);
        Pixel inputPixel = (Pixel)((Object)input2.getAs(0));
        int color = input2.getInt(1);
        double numPartOnAxis = 1.0;
        if (input2.length() == 3) {
            numPartOnAxis = Math.pow(2.0, input2.getInt(2));
        }
        double reversedY = (double)inputPixel.getResolutionY() - inputPixel.getY() - 1.0;
        double truncatedResX = (double)inputPixel.getResolutionX() / numPartOnAxis;
        double truncatedResY = (double)inputPixel.getResolutionY() / numPartOnAxis;
        colorArray = colorArray.$colon$plus(BoxesRunTime.boxToInteger(color), Seq$.MODULE$.canBuildFrom());
        xArray = xArray.$colon$plus(BoxesRunTime.boxToInteger(Predef$.MODULE$.double2Double(inputPixel.getX()).intValue() % Predef$.MODULE$.double2Double(truncatedResX).intValue()), Seq$.MODULE$.canBuildFrom());
        yArray = yArray.$colon$plus(BoxesRunTime.boxToInteger(Predef$.MODULE$.double2Double(reversedY).intValue() % Predef$.MODULE$.double2Double(truncatedResY).intValue()), Seq$.MODULE$.canBuildFrom());
        Predef$.MODULE$.assert(truncatedResX > 0.0);
        Predef$.MODULE$.assert(truncatedResY > 0.0);
        buffer.update(0, colorArray);
        buffer.update(1, xArray);
        buffer.update(2, yArray);
        buffer.update(3, (Object)BoxesRunTime.boxToInteger(Predef$.MODULE$.double2Double(truncatedResX).intValue()));
        buffer.update(4, (Object)BoxesRunTime.boxToInteger(Predef$.MODULE$.double2Double(truncatedResY).intValue()));
    }

    public void merge(MutableAggregationBuffer buffer1, Row buffer2) {
        Seq leftColorArray = (Seq)buffer1.getAs(0);
        Seq leftXArray = (Seq)buffer1.getAs(1);
        Seq leftYArray = (Seq)buffer1.getAs(2);
        int leftResX = buffer1.getInt(3);
        int leftResY = buffer1.getInt(4);
        Seq rightColorArray = (Seq)buffer2.getAs(0);
        Seq rightXArray = (Seq)buffer2.getAs(1);
        Seq rightYArray = (Seq)buffer2.getAs(2);
        int rightResX = buffer2.getInt(3);
        int rightResY = buffer2.getInt(4);
        buffer1.update(0, leftColorArray.$plus$plus(rightColorArray, Seq$.MODULE$.canBuildFrom()));
        buffer1.update(1, leftXArray.$plus$plus(rightXArray, Seq$.MODULE$.canBuildFrom()));
        buffer1.update(2, leftYArray.$plus$plus(rightYArray, Seq$.MODULE$.canBuildFrom()));
        Predef$.MODULE$.assert(Math.max(leftResX, rightResX) > 0);
        Predef$.MODULE$.assert(Math.max(leftResY, rightResY) > 0);
        buffer1.update(3, (Object)BoxesRunTime.boxToInteger(Math.max(leftResX, rightResX)));
        buffer1.update(4, (Object)BoxesRunTime.boxToInteger(Math.max(leftResY, rightResY)));
    }

    public Object evaluate(Row buffer) {
        Seq colorArray = (Seq)buffer.getAs(0);
        Seq xArray = (Seq)buffer.getAs(1);
        Seq yArray = (Seq)buffer.getAs(2);
        int w = BoxesRunTime.unboxToInt(buffer.getAs(3));
        int h = BoxesRunTime.unboxToInt(buffer.getAs(4));
        ObjectRef<BufferedImage> bufferedImage = ObjectRef.create(new BufferedImage(w, h, 2));
        Predef$.MODULE$.assert(xArray.length() == yArray.length());
        Predef$.MODULE$.assert(xArray.length() == colorArray.length());
        xArray.indices().foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new Serializable(this, colorArray, xArray, yArray, bufferedImage){
            public static final long serialVersionUID = 0L;
            private final Seq colorArray$1;
            private final Seq xArray$1;
            private final Seq yArray$1;
            private final ObjectRef bufferedImage$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                ((BufferedImage)this.bufferedImage$1.elem).setRGB(BoxesRunTime.unboxToInt(this.xArray$1.apply(i)), BoxesRunTime.unboxToInt(this.yArray$1.apply(i)), BoxesRunTime.unboxToInt(this.colorArray$1.apply(i)));
            }
            {
                this.colorArray$1 = colorArray$1;
                this.xArray$1 = xArray$1;
                this.yArray$1 = yArray$1;
                this.bufferedImage$1 = bufferedImage$1;
            }
        }));
        return new ImageSerializableWrapper((BufferedImage)bufferedImage.elem);
    }

    public ST_Render copy() {
        return new ST_Render();
    }

    @Override
    public String productPrefix() {
        return "ST_Render";
    }

    @Override
    public int productArity() {
        return 0;
    }

    @Override
    public Object productElement(int x$1) {
        int n = x$1;
        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(x$1)).toString());
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator(this);
    }

    @Override
    public boolean canEqual(Object x$1) {
        return x$1 instanceof ST_Render;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode(this);
    }

    @Override
    public boolean equals(Object x$1) {
        Object object = x$1;
        boolean bl = object instanceof ST_Render;
        return bl && ((ST_Render)x$1).canEqual(this);
    }

    public ST_Render() {
        Logging.class.$init$((Logging)this);
        Product$class.$init$(this);
    }
}

