/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.io;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.sedona_sql.UDT.GeometryUDT;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.coverage.grid.GridCoordinates;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.DirectPosition;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1$mcVI$sp;

public final class GeotiffSchema$ {
    public static GeotiffSchema$ MODULE$;
    private final String undefinedImageType;
    private final StructType columnSchema;
    private final String[] imageFields;
    private final StructType imageSchema;

    static {
        new GeotiffSchema$();
    }

    public String undefinedImageType() {
        return this.undefinedImageType;
    }

    public StructType columnSchema() {
        return this.columnSchema;
    }

    public String[] imageFields() {
        return this.imageFields;
    }

    public StructType imageSchema() {
        return this.imageSchema;
    }

    public String getOrigin(Row row) {
        return row.getString(0);
    }

    public GeometryUDT getGeometry(Row row) {
        return (GeometryUDT)((Object)row.getAs(1));
    }

    public int getHeight(Row row) {
        return row.getInt(2);
    }

    public int getWidth(Row row) {
        return row.getInt(3);
    }

    public int getNBands(Row row) {
        return row.getInt(4);
    }

    public double[] getData(Row row) {
        return (double[])row.getAs(5);
    }

    public Row invalidImageRow(String origin) {
        return Row$.MODULE$.apply(Predef$.MODULE$.genericWrapArray(new Object[]{Row$.MODULE$.apply(Predef$.MODULE$.genericWrapArray(new Object[]{origin, BoxesRunTime.boxToInteger(-1), BoxesRunTime.boxToInteger(-1), BoxesRunTime.boxToInteger(-1), Array$.MODULE$.ofDim(0, ClassTag$.MODULE$.Byte())}))}));
    }

    public Option<Row> decode(String origin, byte[] bytes) {
        Serializable serializable;
        GeoTiffReader geoTiffReader;
        ParameterValue policy = AbstractGridFormat.OVERVIEW_POLICY.createValue();
        policy.setValue((Object)OverviewPolicy.IGNORE);
        ParameterValue gridsize = AbstractGridFormat.SUGGESTED_TILE_SIZE.createValue();
        ParameterValue useJaiRead = AbstractGridFormat.USE_JAI_IMAGEREAD.createValue();
        useJaiRead.setValue(true);
        try {
            geoTiffReader = new GeoTiffReader((Object)new ByteArrayInputStream(bytes));
        }
        catch (RuntimeException runtimeException) {
            geoTiffReader = null;
        }
        GeoTiffReader reader = geoTiffReader;
        ObjectRef<Object> coverage = ObjectRef.create(null);
        if (reader == null) {
            serializable = None$.MODULE$;
        } else {
            coverage.elem = reader.read((GeneralParameterValue[])((Object[])new GeneralParameterValue[]{policy, gridsize, useJaiRead}));
            serializable = BoxedUnit.UNIT;
        }
        CoordinateReferenceSystem source = ((GridCoverage2D)coverage.elem).getCoordinateReferenceSystem();
        CoordinateReferenceSystem target = CRS.decode((String)"EPSG:4326", (boolean)true);
        MathTransform targetCRS = CRS.findMathTransform((CoordinateReferenceSystem)source, (CoordinateReferenceSystem)target);
        GridEnvelope gridRange2D = ((GridCoverage2D)coverage.elem).getGridGeometry().getGridRange();
        int[][] cords = (int[][])((Object[])new int[][]{{gridRange2D.getLow(0), gridRange2D.getLow(1)}, {gridRange2D.getLow(0), gridRange2D.getHigh(1)}, {gridRange2D.getHigh(0), gridRange2D.getHigh(1)}, {gridRange2D.getHigh(0), gridRange2D.getLow(1)}});
        Coordinate[] polyCoordinates = new Coordinate[5];
        IntRef index = IntRef.create(0);
        new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])cords)).foreach((Function1<int[], Object> & Serializable & scala.Serializable)point -> {
            GeotiffSchema$.$anonfun$decode$1(coverage, polyCoordinates, index, point);
            return BoxedUnit.UNIT;
        });
        polyCoordinates[index.elem] = polyCoordinates[0];
        GeometryFactory factory = new GeometryFactory();
        Geometry polygon = JTS.transform((Geometry)factory.createPolygon(polyCoordinates), (MathTransform)targetCRS);
        int nBands = ((GridCoverage2D)coverage.elem).getNumSampleDimensions();
        GridEnvelope dimensions = reader.getOriginalGridRange();
        GridCoordinates maxDimensions = dimensions.getHigh();
        int width = maxDimensions.getCoordinateValue(0) + 1;
        int height = maxDimensions.getCoordinateValue(1) + 1;
        int imageSize = height * width * nBands;
        Predef$.MODULE$.assert((double)imageSize < 1.0E9, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "image is too large");
        double[] decoded = (double[])Array$.MODULE$.ofDim(imageSize, ClassTag$.MODULE$.Double());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), height).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)i -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), width).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)j -> {
            double[] vals = new double[nBands];
            ((GridCoverage2D)coverage$1.elem).evaluate(new GridCoordinates2D(j, i), vals);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nBands).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)bandId -> {
                int offset = i * width + j + nBands * bandId;
                decoded$1[offset] = vals[bandId];
            });
        }));
        return new Some<Row>(Row$.MODULE$.apply(Predef$.MODULE$.genericWrapArray(new Object[]{Row$.MODULE$.apply(Predef$.MODULE$.genericWrapArray(new Object[]{origin, polygon.toText(), BoxesRunTime.boxToInteger(height), BoxesRunTime.boxToInteger(width), BoxesRunTime.boxToInteger(nBands), decoded}))})));
    }

    public static final /* synthetic */ void $anonfun$decode$1(ObjectRef coverage$1, Coordinate[] polyCoordinates$1, IntRef index$1, int[] point) {
        GridCoordinates2D coordinate2D = new GridCoordinates2D(point[0], point[1]);
        DirectPosition result = ((GridCoverage2D)coverage$1.elem).getGridGeometry().gridToWorld(coordinate2D);
        ++index$1.elem;
        polyCoordinates$1[index$1.elem - 1] = new Coordinate(result.getOrdinate(0), result.getOrdinate(1));
    }

    private GeotiffSchema$() {
        MODULE$ = this;
        this.undefinedImageType = "Undefined";
        StructField structField = new StructField("origin", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField2 = new StructField("wkt", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField3 = new StructField("height", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField4 = new StructField("width", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField5 = new StructField("nBands", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField6 = new StructField("data", (DataType)ArrayType$.MODULE$.apply((DataType)DoubleType$.MODULE$), false, StructField$.MODULE$.apply$default$4());
        this.columnSchema = StructType$.MODULE$.apply(Nil$.MODULE$.$colon$colon(structField6).$colon$colon(structField5).$colon$colon(structField4).$colon$colon(structField3).$colon$colon(structField2).$colon$colon(structField));
        this.imageFields = this.columnSchema().fieldNames();
        StructField structField7 = new StructField("image", (DataType)this.columnSchema(), true, StructField$.MODULE$.apply$default$4());
        this.imageSchema = StructType$.MODULE$.apply(Nil$.MODULE$.$colon$colon(structField7));
    }
}

