/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.expressions.simplify;

import org.apache.sedona.core.geometryObjects.Circle;
import org.apache.spark.sql.sedona_sql.expressions.simplify.CircleSimplifier$;
import org.apache.spark.sql.sedona_sql.expressions.simplify.LinestringSimplifier$;
import org.apache.spark.sql.sedona_sql.expressions.simplify.PolygonSimplifier$;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import scala.Array$;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.ClassTag$;
import scala.runtime.RichInt$;

public final class GeometryCollectionSimplifier$ {
    public static final GeometryCollectionSimplifier$ MODULE$;
    private final GeometryFactory geometryFactory;

    static {
        new GeometryCollectionSimplifier$();
    }

    private GeometryFactory geometryFactory() {
        return this.geometryFactory;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Geometry simplify(GeometryCollection geom, boolean preserveCollapsed, double epsilon) {
        GeometryCollection geometryCollection;
        int numberOfGeometries = geom.getNumGeometries();
        Geometry[] geometries = (Geometry[])((TraversableOnce)((TraversableLike)((TraversableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numberOfGeometries).map(new Serializable(geom){
            public static final long serialVersionUID = 0L;
            private final GeometryCollection geom$1;

            public final Geometry apply(int x$1) {
                return this.geom$1.getGeometryN(x$1);
            }
            {
                this.geom$1 = geom$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).map(new Serializable(preserveCollapsed, epsilon){
            public static final long serialVersionUID = 0L;
            private final boolean preserveCollapsed$1;
            private final double epsilon$1;

            public final Geometry apply(Geometry x0$1) {
                Geometry geometry;
                Geometry geometry2 = x0$1;
                if (geometry2 instanceof Circle) {
                    Circle circle = (Circle)geometry2;
                    geometry = CircleSimplifier$.MODULE$.simplify(circle, this.preserveCollapsed$1, this.epsilon$1);
                } else if (geometry2 instanceof LineString) {
                    LineString lineString = (LineString)geometry2;
                    geometry = LinestringSimplifier$.MODULE$.simplify(lineString, this.epsilon$1, this.preserveCollapsed$1);
                } else if (geometry2 instanceof Point) {
                    Point point = (Point)geometry2;
                    geometry = point;
                } else if (geometry2 instanceof Polygon) {
                    Polygon polygon = (Polygon)geometry2;
                    geometry = PolygonSimplifier$.MODULE$.simplify(polygon, this.preserveCollapsed$1, this.epsilon$1);
                } else if (geometry2 instanceof GeometryCollection) {
                    GeometryCollection geometryCollection = (GeometryCollection)geometry2;
                    geometry = GeometryCollectionSimplifier$.MODULE$.simplify(geometryCollection, this.preserveCollapsed$1, this.epsilon$1);
                } else {
                    geometry = null;
                }
                return geometry;
            }
            {
                this.preserveCollapsed$1 = preserveCollapsed$1;
                this.epsilon$1 = epsilon$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).filter(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Geometry x$1) {
                return x$1 != null;
            }
        })).toArray(ClassTag$.MODULE$.apply(Geometry.class));
        String[] distinctGeometries = (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])geometries).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Geometry x$2) {
                return x$2.getGeometryType();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).distinct();
        if (distinctGeometries.length == 1) {
            MultiLineString multiLineString;
            String string2 = (String)Predef$.MODULE$.refArrayOps((Object[])distinctGeometries).head();
            if ("LineString".equals(string2)) {
                multiLineString = this.geometryFactory().createMultiLineString((LineString[])Predef$.MODULE$.refArrayOps((Object[])geometries).map(new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final LineString apply(Geometry x) {
                        return (LineString)x;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LineString.class))));
            } else if ("Polygon".equals(string2)) {
                multiLineString = this.geometryFactory().createMultiPolygon((Polygon[])Predef$.MODULE$.refArrayOps((Object[])geometries).map(new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Polygon apply(Geometry x) {
                        return (Polygon)x;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Polygon.class))));
            } else {
                if (!"Point".equals(string2)) throw new MatchError((Object)string2);
                multiLineString = this.geometryFactory().createMultiPoint((Point[])Predef$.MODULE$.refArrayOps((Object[])geometries).map(new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Point apply(Geometry x) {
                        return (Point)x;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Point.class))));
            }
            geometryCollection = multiLineString;
            return geometryCollection;
        } else {
            geometryCollection = this.geometryFactory().createGeometryCollection(geometries);
        }
        return geometryCollection;
    }

    private GeometryCollectionSimplifier$() {
        MODULE$ = this;
        this.geometryFactory = new GeometryFactory();
    }
}

