/*
 * Decompiled with CFR 0.152.
 */
package org.wololo.jts2geojson;

import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.wololo.geojson.Feature;
import org.wololo.geojson.FeatureCollection;
import org.wololo.geojson.GeometryCollection;
import org.wololo.geojson.MultiPoint;
import org.wololo.geojson.Polygon;
import org.wololo.jts2geojson.GeoJSONReader;

public class GeoJSONWriter {
    static final GeoJSONReader reader = new GeoJSONReader();

    public org.wololo.geojson.Geometry write(Geometry geometry) {
        Class<?> c = geometry.getClass();
        if (c.equals(Point.class)) {
            return this.convert((Point)geometry);
        }
        if (c.equals(LineString.class)) {
            return this.convert((LineString)geometry);
        }
        if (c.equals(LinearRing.class)) {
            return this.convert((LinearRing)geometry);
        }
        if (c.equals(org.locationtech.jts.geom.Polygon.class)) {
            return this.convert((org.locationtech.jts.geom.Polygon)geometry);
        }
        if (c.equals(org.locationtech.jts.geom.MultiPoint.class)) {
            return this.convert((org.locationtech.jts.geom.MultiPoint)geometry);
        }
        if (c.equals(MultiLineString.class)) {
            return this.convert((MultiLineString)geometry);
        }
        if (c.equals(MultiPolygon.class)) {
            return this.convert((MultiPolygon)geometry);
        }
        if (c.equals(org.locationtech.jts.geom.GeometryCollection.class)) {
            return this.convert((org.locationtech.jts.geom.GeometryCollection)geometry);
        }
        throw new UnsupportedOperationException();
    }

    public FeatureCollection write(List<Feature> features) {
        int size2 = features.size();
        Feature[] featuresJson = new Feature[size2];
        for (int i = 0; i < size2; ++i) {
            featuresJson[i] = features.get(i);
        }
        return new FeatureCollection(featuresJson);
    }

    org.wololo.geojson.Point convert(Point point) {
        org.wololo.geojson.Point json = new org.wololo.geojson.Point(this.convert(point.getCoordinate()));
        return json;
    }

    MultiPoint convert(org.locationtech.jts.geom.MultiPoint multiPoint) {
        return new MultiPoint(this.convert(multiPoint.getCoordinates()));
    }

    org.wololo.geojson.LineString convert(LineString lineString) {
        return new org.wololo.geojson.LineString(this.convert(lineString.getCoordinates()));
    }

    org.wololo.geojson.LineString convert(LinearRing ringString) {
        return new org.wololo.geojson.LineString(this.convert(ringString.getCoordinates()));
    }

    org.wololo.geojson.MultiLineString convert(MultiLineString multiLineString) {
        int size2 = multiLineString.getNumGeometries();
        double[][][] lineStrings = new double[size2][][];
        for (int i = 0; i < size2; ++i) {
            lineStrings[i] = this.convert(multiLineString.getGeometryN(i).getCoordinates());
        }
        return new org.wololo.geojson.MultiLineString(lineStrings);
    }

    Polygon convert(org.locationtech.jts.geom.Polygon polygon) {
        int size2 = polygon.getNumInteriorRing() + 1;
        double[][][] rings = new double[size2][][];
        rings[0] = this.convert(polygon.getExteriorRing().getCoordinates());
        for (int i = 0; i < size2 - 1; ++i) {
            rings[i + 1] = this.convert(polygon.getInteriorRingN(i).getCoordinates());
        }
        return new Polygon(rings);
    }

    org.wololo.geojson.MultiPolygon convert(MultiPolygon multiPolygon) {
        int size2 = multiPolygon.getNumGeometries();
        double[][][][] polygons = new double[size2][][][];
        for (int i = 0; i < size2; ++i) {
            polygons[i] = this.convert((org.locationtech.jts.geom.Polygon)multiPolygon.getGeometryN(i)).getCoordinates();
        }
        return new org.wololo.geojson.MultiPolygon(polygons);
    }

    GeometryCollection convert(org.locationtech.jts.geom.GeometryCollection gc) {
        int size2 = gc.getNumGeometries();
        org.wololo.geojson.Geometry[] geometries = new org.wololo.geojson.Geometry[size2];
        for (int i = 0; i < size2; ++i) {
            geometries[i] = this.write(gc.getGeometryN(i));
        }
        return new GeometryCollection(geometries);
    }

    double[] convert(Coordinate coordinate) {
        if (Double.isNaN(coordinate.getZ())) {
            return new double[]{coordinate.x, coordinate.y};
        }
        return new double[]{coordinate.x, coordinate.y, coordinate.getZ()};
    }

    double[][] convert(Coordinate[] coordinates) {
        double[][] array = new double[coordinates.length][];
        for (int i = 0; i < coordinates.length; ++i) {
            array[i] = this.convert(coordinates[i]);
        }
        return array;
    }
}

