/*
 * Decompiled with CFR 0.152.
 */
package org.wololo.jts2geojson;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.PrecisionModel;
import org.wololo.geojson.GeoJSON;
import org.wololo.geojson.GeoJSONFactory;
import org.wololo.geojson.GeometryCollection;
import org.wololo.geojson.LineString;
import org.wololo.geojson.MultiLineString;
import org.wololo.geojson.MultiPoint;
import org.wololo.geojson.MultiPolygon;
import org.wololo.geojson.Point;
import org.wololo.geojson.Polygon;

public class GeoJSONReader {
    static final GeometryFactory FACTORY = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING));

    public Geometry read(String json) {
        return this.read(json, null);
    }

    public Geometry read(String json, GeometryFactory geomFactory) {
        GeoJSON geoJSON = GeoJSONFactory.create(json);
        return this.read(geoJSON, geomFactory);
    }

    public Geometry read(GeoJSON geoJSON) {
        return this.read(geoJSON, null);
    }

    public Geometry read(GeoJSON geoJSON, GeometryFactory geomFactory) {
        GeometryFactory factory = geomFactory != null ? geomFactory : FACTORY;
        if (geoJSON instanceof Point) {
            return this.convert((Point)geoJSON, factory);
        }
        if (geoJSON instanceof LineString) {
            return this.convert((LineString)geoJSON, factory);
        }
        if (geoJSON instanceof Polygon) {
            return this.convert((Polygon)geoJSON, factory);
        }
        if (geoJSON instanceof MultiPoint) {
            return this.convert((MultiPoint)geoJSON, factory);
        }
        if (geoJSON instanceof MultiLineString) {
            return this.convert((MultiLineString)geoJSON, factory);
        }
        if (geoJSON instanceof MultiPolygon) {
            return this.convert((MultiPolygon)geoJSON, factory);
        }
        if (geoJSON instanceof GeometryCollection) {
            return this.convert((GeometryCollection)geoJSON, factory);
        }
        throw new UnsupportedOperationException();
    }

    Geometry convert(Point point, GeometryFactory factory) {
        return factory.createPoint(this.convert(point.getCoordinates()));
    }

    Geometry convert(MultiPoint multiPoint, GeometryFactory factory) {
        return factory.createMultiPointFromCoords(this.convert(multiPoint.getCoordinates()));
    }

    Geometry convert(LineString lineString, GeometryFactory factory) {
        return factory.createLineString(this.convert(lineString.getCoordinates()));
    }

    Geometry convert(MultiLineString multiLineString, GeometryFactory factory) {
        int size2 = multiLineString.getCoordinates().length;
        org.locationtech.jts.geom.LineString[] lineStrings = new org.locationtech.jts.geom.LineString[size2];
        for (int i = 0; i < size2; ++i) {
            lineStrings[i] = factory.createLineString(this.convert(multiLineString.getCoordinates()[i]));
        }
        return factory.createMultiLineString(lineStrings);
    }

    Geometry convert(Polygon polygon, GeometryFactory factory) {
        return this.convertToPolygon(polygon.getCoordinates(), factory);
    }

    org.locationtech.jts.geom.Polygon convertToPolygon(double[][][] coordinates, GeometryFactory factory) {
        LinearRing shell = factory.createLinearRing(this.convert(coordinates[0]));
        if (coordinates.length > 1) {
            int size2 = coordinates.length - 1;
            LinearRing[] holes = new LinearRing[size2];
            for (int i = 0; i < size2; ++i) {
                holes[i] = factory.createLinearRing(this.convert(coordinates[i + 1]));
            }
            return factory.createPolygon(shell, holes);
        }
        return factory.createPolygon(shell);
    }

    Geometry convert(MultiPolygon multiPolygon, GeometryFactory factory) {
        int size2 = multiPolygon.getCoordinates().length;
        org.locationtech.jts.geom.Polygon[] polygons = new org.locationtech.jts.geom.Polygon[size2];
        for (int i = 0; i < size2; ++i) {
            polygons[i] = this.convertToPolygon(multiPolygon.getCoordinates()[i], factory);
        }
        return factory.createMultiPolygon(polygons);
    }

    Geometry convert(GeometryCollection gc, GeometryFactory factory) {
        int size2 = gc.getGeometries().length;
        Geometry[] geometries = new Geometry[size2];
        for (int i = 0; i < size2; ++i) {
            geometries[i] = this.read(gc.getGeometries()[i], factory);
        }
        return factory.createGeometryCollection(geometries);
    }

    Coordinate convert(double[] c) {
        if (c.length == 2) {
            return new Coordinate(c[0], c[1]);
        }
        return new Coordinate(c[0], c[1], c[2]);
    }

    Coordinate[] convert(double[][] ca) {
        Coordinate[] coordinates = new Coordinate[ca.length];
        for (int i = 0; i < ca.length; ++i) {
            coordinates[i] = this.convert(ca[i]);
        }
        return coordinates;
    }
}

