/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.triangulate.quadedge;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.triangulate.quadedge.Vertex;

public class QuadEdge {
    private QuadEdge rot;
    private Vertex vertex;
    private QuadEdge next;
    private Object data = null;

    public static QuadEdge makeEdge(Vertex o, Vertex d) {
        QuadEdge q0 = new QuadEdge();
        QuadEdge q1 = new QuadEdge();
        QuadEdge q2 = new QuadEdge();
        QuadEdge q3 = new QuadEdge();
        q0.rot = q1;
        q1.rot = q2;
        q2.rot = q3;
        q3.rot = q0;
        q0.setNext(q0);
        q1.setNext(q3);
        q2.setNext(q2);
        q3.setNext(q1);
        QuadEdge base = q0;
        base.setOrig(o);
        base.setDest(d);
        return base;
    }

    public static QuadEdge connect(QuadEdge a, QuadEdge b) {
        QuadEdge e = QuadEdge.makeEdge(a.dest(), b.orig());
        QuadEdge.splice(e, a.lNext());
        QuadEdge.splice(e.sym(), b);
        return e;
    }

    public static void splice(QuadEdge a, QuadEdge b) {
        QuadEdge alpha = a.oNext().rot();
        QuadEdge beta = b.oNext().rot();
        QuadEdge t1 = b.oNext();
        QuadEdge t2 = a.oNext();
        QuadEdge t3 = beta.oNext();
        QuadEdge t4 = alpha.oNext();
        a.setNext(t1);
        b.setNext(t2);
        alpha.setNext(t3);
        beta.setNext(t4);
    }

    public static void swap(QuadEdge e) {
        QuadEdge a = e.oPrev();
        QuadEdge b = e.sym().oPrev();
        QuadEdge.splice(e, a);
        QuadEdge.splice(e.sym(), b);
        QuadEdge.splice(e, a.lNext());
        QuadEdge.splice(e.sym(), b.lNext());
        e.setOrig(a.dest());
        e.setDest(b.dest());
    }

    private QuadEdge() {
    }

    public QuadEdge getPrimary() {
        if (this.orig().getCoordinate().compareTo(this.dest().getCoordinate()) <= 0) {
            return this;
        }
        return this.sym();
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Object getData() {
        return this.data;
    }

    public void delete() {
        this.rot = null;
    }

    public boolean isLive() {
        return this.rot != null;
    }

    public void setNext(QuadEdge next2) {
        this.next = next2;
    }

    public final QuadEdge rot() {
        return this.rot;
    }

    public final QuadEdge invRot() {
        return this.rot.sym();
    }

    public final QuadEdge sym() {
        return this.rot.rot;
    }

    public final QuadEdge oNext() {
        return this.next;
    }

    public final QuadEdge oPrev() {
        return this.rot.next.rot;
    }

    public final QuadEdge dNext() {
        return this.sym().oNext().sym();
    }

    public final QuadEdge dPrev() {
        return this.invRot().oNext().invRot();
    }

    public final QuadEdge lNext() {
        return this.invRot().oNext().rot();
    }

    public final QuadEdge lPrev() {
        return this.next.sym();
    }

    public final QuadEdge rNext() {
        return this.rot.next.invRot();
    }

    public final QuadEdge rPrev() {
        return this.sym().oNext();
    }

    void setOrig(Vertex o) {
        this.vertex = o;
    }

    void setDest(Vertex d) {
        this.sym().setOrig(d);
    }

    public final Vertex orig() {
        return this.vertex;
    }

    public final Vertex dest() {
        return this.sym().orig();
    }

    public double getLength() {
        return this.orig().getCoordinate().distance(this.dest().getCoordinate());
    }

    public boolean equalsNonOriented(QuadEdge qe) {
        if (this.equalsOriented(qe)) {
            return true;
        }
        return this.equalsOriented(qe.sym());
    }

    public boolean equalsOriented(QuadEdge qe) {
        return this.orig().getCoordinate().equals2D(qe.orig().getCoordinate()) && this.dest().getCoordinate().equals2D(qe.dest().getCoordinate());
    }

    public LineSegment toLineSegment() {
        return new LineSegment(this.vertex.getCoordinate(), this.dest().getCoordinate());
    }

    public String toString() {
        Coordinate p0 = this.vertex.getCoordinate();
        Coordinate p1 = this.dest().getCoordinate();
        return WKTWriter.toLineString(p0, p1);
    }
}

