/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.noding.snap.SnappingNoder;
import org.locationtech.jts.operation.overlayng.OverlayNG;
import org.locationtech.jts.operation.overlayng.PrecisionUtil;
import org.locationtech.jts.operation.union.UnaryUnionOp;
import org.locationtech.jts.operation.union.UnionStrategy;

public class OverlayNGRobust {
    private static final int NUM_SNAP_TRIES = 5;
    private static final double SNAP_TOL_FACTOR = 1.0E12;

    public static Geometry union(Geometry geom) {
        UnionStrategy unionSRFun = new UnionStrategy(){

            @Override
            public Geometry union(Geometry g0, Geometry g1) {
                return OverlayNGRobust.overlay(g0, g1, 2);
            }

            @Override
            public boolean isFloatingPrecision() {
                return true;
            }
        };
        UnaryUnionOp op = new UnaryUnionOp(geom);
        op.setUnionFunction(unionSRFun);
        return op.union();
    }

    public static Geometry overlay(Geometry geom0, Geometry geom1, int opCode) {
        try {
            Geometry result2 = OverlayNG.overlay(geom0, geom1, opCode);
            return result2;
        }
        catch (RuntimeException ex) {
            RuntimeException exOriginal = ex;
            Geometry result3 = OverlayNGRobust.overlaySnapTries(geom0, geom1, opCode);
            if (result3 != null) {
                return result3;
            }
            result3 = OverlayNGRobust.overlaySR(geom0, geom1, opCode);
            if (result3 != null) {
                return result3;
            }
            throw exOriginal;
        }
    }

    private static Geometry overlaySnapTries(Geometry geom0, Geometry geom1, int opCode) {
        double snapTol = OverlayNGRobust.snapTolerance(geom0, geom1);
        for (int i = 0; i < 5; ++i) {
            Geometry result2 = OverlayNGRobust.overlaySnapping(geom0, geom1, opCode, snapTol);
            if (result2 != null) {
                return result2;
            }
            result2 = OverlayNGRobust.overlaySnapBoth(geom0, geom1, opCode, snapTol);
            if (result2 != null) {
                return result2;
            }
            snapTol *= 10.0;
        }
        return null;
    }

    private static Geometry overlaySnapping(Geometry geom0, Geometry geom1, int opCode, double snapTol) {
        try {
            return OverlayNGRobust.overlaySnapTol(geom0, geom1, opCode, snapTol);
        }
        catch (TopologyException topologyException) {
            return null;
        }
    }

    private static Geometry overlaySnapBoth(Geometry geom0, Geometry geom1, int opCode, double snapTol) {
        try {
            Geometry snap0 = OverlayNGRobust.snapSelf(geom0, snapTol);
            Geometry snap1 = OverlayNGRobust.snapSelf(geom1, snapTol);
            return OverlayNGRobust.overlaySnapTol(snap0, snap1, opCode, snapTol);
        }
        catch (TopologyException topologyException) {
            return null;
        }
    }

    private static Geometry snapSelf(Geometry geom, double snapTol) {
        OverlayNG ov = new OverlayNG(geom, null);
        SnappingNoder snapNoder = new SnappingNoder(snapTol);
        ov.setNoder(snapNoder);
        ov.setStrictMode(true);
        return ov.getResult();
    }

    private static Geometry overlaySnapTol(Geometry geom0, Geometry geom1, int opCode, double snapTol) {
        SnappingNoder snapNoder = new SnappingNoder(snapTol);
        return OverlayNG.overlay(geom0, geom1, opCode, snapNoder);
    }

    private static double snapTolerance(Geometry geom0, Geometry geom1) {
        double tol0 = OverlayNGRobust.snapTolerance(geom0);
        double tol1 = OverlayNGRobust.snapTolerance(geom1);
        double snapTol = Math.max(tol0, tol1);
        return snapTol;
    }

    private static double snapTolerance(Geometry geom) {
        double magnitude = OverlayNGRobust.ordinateMagnitude(geom);
        return magnitude / 1.0E12;
    }

    private static double ordinateMagnitude(Geometry geom) {
        if (geom == null) {
            return 0.0;
        }
        Envelope env = geom.getEnvelopeInternal();
        double magMax = Math.max(Math.abs(env.getMaxX()), Math.abs(env.getMaxY()));
        double magMin = Math.max(Math.abs(env.getMinX()), Math.abs(env.getMinY()));
        return Math.max(magMax, magMin);
    }

    private static Geometry overlaySR(Geometry geom0, Geometry geom1, int opCode) {
        try {
            double scaleSafe = PrecisionUtil.safeScale(geom0, geom1);
            PrecisionModel pmSafe = new PrecisionModel(scaleSafe);
            Geometry result2 = OverlayNG.overlay(geom0, geom1, opCode, pmSafe);
            return result2;
        }
        catch (TopologyException topologyException) {
            return null;
        }
    }
}

