/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.io;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

public class OrdinateFormat {
    private static final String DECIMAL_PATTERN = "0";
    public static final String REP_POS_INF = "Inf";
    public static final String REP_NEG_INF = "-Inf";
    public static final String REP_NAN = "NaN";
    public static final int MAX_FRACTION_DIGITS = 325;
    public static OrdinateFormat DEFAULT = new OrdinateFormat();
    private DecimalFormat format;

    public static OrdinateFormat create(int maximumFractionDigits) {
        return new OrdinateFormat(maximumFractionDigits);
    }

    public OrdinateFormat() {
        this.format = OrdinateFormat.createFormat(325);
    }

    public OrdinateFormat(int maximumFractionDigits) {
        this.format = OrdinateFormat.createFormat(maximumFractionDigits);
    }

    private static DecimalFormat createFormat(int maximumFractionDigits) {
        DecimalFormat format2;
        NumberFormat nf = NumberFormat.getInstance(Locale.US);
        try {
            format2 = (DecimalFormat)nf;
        }
        catch (ClassCastException ex) {
            throw new RuntimeException("Unable to create DecimalFormat for Locale.US");
        }
        format2.applyPattern(DECIMAL_PATTERN);
        format2.setMaximumFractionDigits(maximumFractionDigits);
        return format2;
    }

    public synchronized String format(double ord) {
        if (Double.isNaN(ord)) {
            return REP_NAN;
        }
        if (Double.isInfinite(ord)) {
            return ord > 0.0 ? REP_POS_INF : REP_NEG_INF;
        }
        return this.format.format(ord);
    }
}

