/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.bintree;

import org.locationtech.jts.index.bintree.Interval;
import org.locationtech.jts.index.quadtree.DoubleBits;

public class Key {
    private double pt = 0.0;
    private int level = 0;
    private Interval interval;

    public static int computeLevel(Interval interval) {
        double dx = interval.getWidth();
        int level = DoubleBits.exponent(dx) + 1;
        return level;
    }

    public Key(Interval interval) {
        this.computeKey(interval);
    }

    public double getPoint() {
        return this.pt;
    }

    public int getLevel() {
        return this.level;
    }

    public Interval getInterval() {
        return this.interval;
    }

    public void computeKey(Interval itemInterval) {
        this.level = Key.computeLevel(itemInterval);
        this.interval = new Interval();
        this.computeInterval(this.level, itemInterval);
        while (!this.interval.contains(itemInterval)) {
            ++this.level;
            this.computeInterval(this.level, itemInterval);
        }
    }

    private void computeInterval(int level, Interval itemInterval) {
        double size2 = DoubleBits.powerOf2(level);
        this.pt = Math.floor(itemInterval.getMin() / size2) * size2;
        this.interval.init(this.pt, this.pt + size2);
    }
}

