/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geomgraph.index;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Quadrant;
import org.locationtech.jts.util.IntArrayList;

public class MonotoneChainIndexer {
    public static int[] toIntArray(List list) {
        int[] array = new int[list.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (Integer)list.get(i);
        }
        return array;
    }

    public int[] getChainStartIndices(Coordinate[] pts) {
        int last2;
        int start = 0;
        IntArrayList startIndexList = new IntArrayList(pts.length / 2);
        startIndexList.add(start);
        do {
            last2 = this.findChainEnd(pts, start);
            startIndexList.add(last2);
        } while ((start = last2) < pts.length - 1);
        return startIndexList.toArray();
    }

    public int[] OLDgetChainStartIndices(Coordinate[] pts) {
        int last2;
        int start = 0;
        ArrayList<Integer> startIndexList = new ArrayList<Integer>();
        startIndexList.add(start);
        do {
            last2 = this.findChainEnd(pts, start);
            startIndexList.add(last2);
        } while ((start = last2) < pts.length - 1);
        int[] startIndex = MonotoneChainIndexer.toIntArray(startIndexList);
        return startIndex;
    }

    private int findChainEnd(Coordinate[] pts, int start) {
        int quad;
        int last2;
        int chainQuad = Quadrant.quadrant(pts[start], pts[start + 1]);
        for (last2 = start + 1; last2 < pts.length && (quad = Quadrant.quadrant(pts[last2 - 1], pts[last2])) == chainQuad; ++last2) {
        }
        return last2 - 1;
    }
}

