/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.io;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.sedona_sql.UDT.GeometryUDT;
import org.apache.spark.sql.sedona_sql.io.GeotiffSchema$;
import org.apache.spark.sql.sedona_sql.io.GeotiffSchema$$anonfun$decode$1$;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.coverage.grid.GridCoordinates;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.DirectPosition;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class GeotiffSchema$ {
    public static final GeotiffSchema$ MODULE$;
    private final String undefinedImageType;
    private final StructType columnSchema;
    private final String[] imageFields;
    private final StructType imageSchema;

    static {
        new GeotiffSchema$();
    }

    public String undefinedImageType() {
        return this.undefinedImageType;
    }

    public StructType columnSchema() {
        return this.columnSchema;
    }

    public String[] imageFields() {
        return this.imageFields;
    }

    public StructType imageSchema() {
        return this.imageSchema;
    }

    public String getOrigin(Row row) {
        return row.getString(0);
    }

    public GeometryUDT getGeometry(Row row) {
        return (GeometryUDT)((Object)row.getAs(1));
    }

    public int getHeight(Row row) {
        return row.getInt(2);
    }

    public int getWidth(Row row) {
        return row.getInt(3);
    }

    public int getNBands(Row row) {
        return row.getInt(4);
    }

    public double[] getData(Row row) {
        return (double[])row.getAs(5);
    }

    public Row invalidImageRow(String origin) {
        return Row$.MODULE$.apply(Predef$.MODULE$.genericWrapArray(new Object[]{Row$.MODULE$.apply(Predef$.MODULE$.genericWrapArray(new Object[]{origin, BoxesRunTime.boxToInteger(-1), BoxesRunTime.boxToInteger(-1), BoxesRunTime.boxToInteger(-1), Array$.MODULE$.ofDim(0, ClassTag$.MODULE$.Byte())}))}));
    }

    public Option<Row> decode(String origin, byte[] bytes) {
        Serializable serializable;
        GeoTiffReader geoTiffReader;
        ParameterValue policy = AbstractGridFormat.OVERVIEW_POLICY.createValue();
        policy.setValue((Object)OverviewPolicy.IGNORE);
        ParameterValue gridsize = AbstractGridFormat.SUGGESTED_TILE_SIZE.createValue();
        ParameterValue useJaiRead = AbstractGridFormat.USE_JAI_IMAGEREAD.createValue();
        useJaiRead.setValue(true);
        try {
            geoTiffReader = new GeoTiffReader((Object)new ByteArrayInputStream(bytes));
        }
        catch (RuntimeException runtimeException) {
            geoTiffReader = null;
        }
        GeoTiffReader reader = geoTiffReader;
        ObjectRef<Object> coverage = ObjectRef.create(null);
        if (reader == null) {
            serializable = None$.MODULE$;
        } else {
            coverage.elem = reader.read((GeneralParameterValue[])((Object[])new GeneralParameterValue[]{policy, gridsize, useJaiRead}));
            serializable = BoxedUnit.UNIT;
        }
        CoordinateReferenceSystem source = ((GridCoverage2D)coverage.elem).getCoordinateReferenceSystem();
        CoordinateReferenceSystem target = CRS.decode((String)"EPSG:4326", (boolean)true);
        MathTransform targetCRS = CRS.findMathTransform((CoordinateReferenceSystem)source, (CoordinateReferenceSystem)target);
        GridEnvelope gridRange2D = ((GridCoverage2D)coverage.elem).getGridGeometry().getGridRange();
        int[][] cords = (int[][])((Object[])new int[][]{{gridRange2D.getLow(0), gridRange2D.getLow(1)}, {gridRange2D.getLow(0), gridRange2D.getHigh(1)}, {gridRange2D.getHigh(0), gridRange2D.getHigh(1)}, {gridRange2D.getHigh(0), gridRange2D.getLow(1)}});
        Coordinate[] polyCoordinates = new Coordinate[5];
        IntRef index = IntRef.create(0);
        Predef$.MODULE$.refArrayOps((Object[])cords).foreach(new scala.Serializable(coverage, polyCoordinates, index){
            public static final long serialVersionUID = 0L;
            private final ObjectRef coverage$1;
            private final Coordinate[] polyCoordinates$1;
            private final IntRef index$1;

            public final void apply(int[] point) {
                GridCoordinates2D coordinate2D = new GridCoordinates2D(point[0], point[1]);
                DirectPosition result2 = ((GridCoverage2D)this.coverage$1.elem).getGridGeometry().gridToWorld(coordinate2D);
                ++this.index$1.elem;
                this.polyCoordinates$1[this.index$1.elem - 1] = new Coordinate(result2.getOrdinate(0), result2.getOrdinate(1));
            }
            {
                this.coverage$1 = coverage$1;
                this.polyCoordinates$1 = polyCoordinates$1;
                this.index$1 = index$1;
            }
        });
        polyCoordinates[index.elem] = polyCoordinates[0];
        GeometryFactory factory = new GeometryFactory();
        Geometry polygon = JTS.transform((Geometry)factory.createPolygon(polyCoordinates), (MathTransform)targetCRS);
        int nBands = ((GridCoverage2D)coverage.elem).getNumSampleDimensions();
        GridEnvelope dimensions = reader.getOriginalGridRange();
        GridCoordinates maxDimensions = dimensions.getHigh();
        int width = maxDimensions.getCoordinateValue(0) + 1;
        int height = maxDimensions.getCoordinateValue(1) + 1;
        int imageSize = height * width * nBands;
        Predef$.MODULE$.assert((double)imageSize < 1.0E9, (Function0<Object>)((Object)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "image is too large";
            }
        }));
        double[] decoded = (double[])Array$.MODULE$.ofDim(imageSize, ClassTag$.MODULE$.Double());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), height).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new scala.Serializable(coverage, nBands, width, decoded){
            public static final long serialVersionUID = 0L;
            public final ObjectRef coverage$1;
            public final int nBands$1;
            public final int width$1;
            public final double[] decoded$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.width$1).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new scala.Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.decode.1 $outer;
                    public final int i$1;

                    public final void apply(int j) {
                        this.apply$mcVI$sp(j);
                    }

                    public void apply$mcVI$sp(int j) {
                        double[] vals = new double[this.$outer.nBands$1];
                        ((GridCoverage2D)this.$outer.coverage$1.elem).evaluate(new GridCoordinates2D(j, this.i$1), vals);
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.nBands$1).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new scala.Serializable(this, vals, j){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$decode$1$$anonfun$apply$mcVI$sp$1 $outer;
                            private final double[] vals$1;
                            private final int j$1;

                            public final void apply(int bandId) {
                                this.apply$mcVI$sp(bandId);
                            }

                            public void apply$mcVI$sp(int bandId) {
                                int offset = this.$outer.i$1 * this.$outer.org$apache$spark$sql$sedona_sql$io$GeotiffSchema$$anonfun$$anonfun$$$outer().width$1 + this.j$1 + this.$outer.org$apache$spark$sql$sedona_sql$io$GeotiffSchema$$anonfun$$anonfun$$$outer().nBands$1 * bandId;
                                this.$outer.org$apache$spark$sql$sedona_sql$io$GeotiffSchema$$anonfun$$anonfun$$$outer().decoded$1[offset] = this.vals$1[bandId];
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.vals$1 = vals$1;
                                this.j$1 = j$1;
                            }
                        }));
                    }

                    public /* synthetic */ anonfun.decode.1 org$apache$spark$sql$sedona_sql$io$GeotiffSchema$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.i$1 = i$1;
                    }
                }));
            }
            {
                this.coverage$1 = coverage$1;
                this.nBands$1 = nBands$1;
                this.width$1 = width$1;
                this.decoded$1 = decoded$1;
            }
        }));
        return new Some<Row>(Row$.MODULE$.apply(Predef$.MODULE$.genericWrapArray(new Object[]{Row$.MODULE$.apply(Predef$.MODULE$.genericWrapArray(new Object[]{origin, polygon.toText(), BoxesRunTime.boxToInteger(height), BoxesRunTime.boxToInteger(width), BoxesRunTime.boxToInteger(nBands), decoded}))})));
    }

    private GeotiffSchema$() {
        MODULE$ = this;
        this.undefinedImageType = "Undefined";
        StructField structField = new StructField("origin", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField2 = new StructField("wkt", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField3 = new StructField("height", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField4 = new StructField("width", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField5 = new StructField("nBands", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField6 = new StructField("data", (DataType)ArrayType$.MODULE$.apply((DataType)DoubleType$.MODULE$), false, StructField$.MODULE$.apply$default$4());
        this.columnSchema = StructType$.MODULE$.apply(Nil$.MODULE$.$colon$colon(structField6).$colon$colon(structField5).$colon$colon(structField4).$colon$colon(structField3).$colon$colon(structField2).$colon$colon(structField));
        this.imageFields = this.columnSchema().fieldNames();
        StructField structField7 = new StructField("image", (DataType)this.columnSchema(), true, StructField$.MODULE$.apply$default$4());
        this.imageSchema = StructType$.MODULE$.apply(Nil$.MODULE$.$colon$colon(structField7));
    }
}

