/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.io;

import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sedona_sql.io.GeotiffSchema$;
import org.apache.spark.sql.sedona_sql.io.ImageOptions;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Mb!B\u0001\u0003\u0001!q!!E$f_RLgM\u001a$jY\u00164uN]7bi*\u00111\u0001B\u0001\u0003S>T!!\u0002\u0004\u0002\u0015M,Gm\u001c8b?N\fHN\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001cB\u0001A\b\u0016;A\u0011\u0001cE\u0007\u0002#)\t!#A\u0003tG\u0006d\u0017-\u0003\u0002\u0015#\t1\u0011I\\=SK\u001a\u0004\"AF\u000e\u000e\u0003]Q!\u0001G\r\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u00035\u0019\t\u0011\"\u001a=fGV$\u0018n\u001c8\n\u0005q9\"A\u0003$jY\u00164uN]7biB\u0011a$I\u0007\u0002?)\u0011\u0001EB\u0001\bg>,(oY3t\u0013\t\u0011sD\u0001\nECR\f7k\\;sG\u0016\u0014VmZ5ti\u0016\u0014\b\"\u0002\u0013\u0001\t\u00031\u0013A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003\u001d\u0002\"\u0001\u000b\u0001\u000e\u0003\tAQA\u000b\u0001\u0005B-\n1\"\u001b8gKJ\u001c6\r[3nCR!A&N\u001eH!\r\u0001RfL\u0005\u0003]E\u0011aa\u00149uS>t\u0007C\u0001\u00194\u001b\u0005\t$B\u0001\u001a\u0007\u0003\u0015!\u0018\u0010]3t\u0013\t!\u0014G\u0001\u0006TiJ,8\r\u001e+za\u0016DQAN\u0015A\u0002]\nAb\u001d9be.\u001cVm]:j_:\u0004\"\u0001O\u001d\u000e\u0003\u0019I!A\u000f\u0004\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\t\u000bqJ\u0003\u0019A\u001f\u0002\u000f=\u0004H/[8ogB!a(\u0011#E\u001d\t\u0001r(\u0003\u0002A#\u00051\u0001K]3eK\u001aL!AQ\"\u0003\u00075\u000b\u0007O\u0003\u0002A#A\u0011a(R\u0005\u0003\r\u000e\u0013aa\u0015;sS:<\u0007\"\u0002%*\u0001\u0004I\u0015!\u00024jY\u0016\u001c\bc\u0001&S+:\u00111\n\u0015\b\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001d\u0016\na\u0001\u0010:p_Rt\u0014\"\u0001\n\n\u0005E\u000b\u0012a\u00029bG.\fw-Z\u0005\u0003'R\u00131aU3r\u0015\t\t\u0016\u0003\u0005\u0002W76\tqK\u0003\u0002Y3\u0006\u0011am\u001d\u0006\u00035*\ta\u0001[1e_>\u0004\u0018B\u0001/X\u0005)1\u0015\u000e\\3Ti\u0006$Xo\u001d\u0005\u0006=\u0002!\teX\u0001\raJ,\u0007/\u0019:f/JLG/\u001a\u000b\u0006A\u000e$G.\u001c\t\u0003-\u0005L!AY\f\u0003'=+H\u000f];u/JLG/\u001a:GC\u000e$xN]=\t\u000bYj\u0006\u0019A\u001c\t\u000b\u0015l\u0006\u0019\u00014\u0002\u0007)|'\r\u0005\u0002hU6\t\u0001N\u0003\u0002j3\u0006IQ.\u00199sK\u0012,8-Z\u0005\u0003W\"\u00141AS8c\u0011\u0015aT\f1\u0001>\u0011\u0015qW\f1\u00010\u0003)!\u0017\r^1TG\",W.\u0019\u0005\u0006a\u0002!\t%]\u0001\ng\"|'\u000f\u001e(b[\u0016$\u0012\u0001\u0012\u0005\u0006g\u0002!\t\u0006^\u0001\fEVLG\u000e\u001a*fC\u0012,'\u000fF\bv\u0003\u0013\tY!!\u0004\u0002\u0012\u0005U\u0011\u0011EA\u0012!\u0011\u0001b\u000f_>\n\u0005]\f\"!\u0003$v]\u000e$\u0018n\u001c82!\t1\u00120\u0003\u0002{/\ty\u0001+\u0019:uSRLwN\\3e\r&dW\rE\u0002KyzL!! +\u0003\u0011%#XM]1u_J\u00042a`A\u0003\u001b\t\t\tAC\u0002\u0002\u0004\u0019\t\u0001bY1uC2L8\u000f^\u0005\u0005\u0003\u000f\t\tAA\u0006J]R,'O\\1m%><\b\"\u0002\u001cs\u0001\u00049\u0004\"\u00028s\u0001\u0004y\u0003BBA\be\u0002\u0007q&A\bqCJ$\u0018\u000e^5p]N\u001b\u0007.Z7b\u0011\u0019\t\u0019B\u001da\u0001_\u0005q!/Z9vSJ,GmU2iK6\f\u0007bBA\fe\u0002\u0007\u0011\u0011D\u0001\bM&dG/\u001a:t!\u0011Q%+a\u0007\u0011\u0007y\ti\"C\u0002\u0002 }\u0011aAR5mi\u0016\u0014\b\"\u0002\u001fs\u0001\u0004i\u0004bBA\u0013e\u0002\u0007\u0011qE\u0001\u000bQ\u0006$wn\u001c9D_:4\u0007\u0003BA\u0015\u0003_i!!a\u000b\u000b\u0007\u00055\u0012,\u0001\u0003d_:4\u0017\u0002BA\u0019\u0003W\u0011QbQ8oM&<WO]1uS>t\u0007")
public class GeotiffFileFormat
implements FileFormat,
DataSourceRegister {
    public boolean supportBatch(SparkSession sparkSession, StructType dataSchema) {
        return FileFormat.class.supportBatch((FileFormat)this, (SparkSession)sparkSession, (StructType)dataSchema);
    }

    public Option<Seq<String>> vectorTypes(StructType requiredSchema, StructType partitionSchema, SQLConf sqlConf) {
        return FileFormat.class.vectorTypes((FileFormat)this, (StructType)requiredSchema, (StructType)partitionSchema, (SQLConf)sqlConf);
    }

    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        return FileFormat.class.isSplitable((FileFormat)this, (SparkSession)sparkSession, options, (Path)path);
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        return FileFormat.class.buildReaderWithPartitionValues((FileFormat)this, (SparkSession)sparkSession, (StructType)dataSchema, (StructType)partitionSchema, (StructType)requiredSchema, filters, options, (Configuration)hadoopConf);
    }

    public boolean supportDataType(DataType dataType, boolean isReadPath) {
        return FileFormat.class.supportDataType((FileFormat)this, (DataType)dataType, (boolean)isReadPath);
    }

    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        return new Some<StructType>(GeotiffSchema$.MODULE$.imageSchema());
    }

    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        throw new UnsupportedOperationException("Write is not supported for image data source");
    }

    public String shortName() {
        return "geotiff";
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        Predef$.MODULE$.assert(requiredSchema.length() <= 1, (Function0<Object>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Image data source only produces a single data column named \"image\".";
            }
        }));
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        ImageOptions imageSourceOptions = new ImageOptions(options);
        return new Serializable(this, requiredSchema, broadcastedHadoopConf, imageSourceOptions){
            public static final long serialVersionUID = 0L;
            private final StructType requiredSchema$1;
            private final Broadcast broadcastedHadoopConf$1;
            private final ImageOptions imageSourceOptions$1;

            public final Iterator<InternalRow> apply(PartitionedFile file) {
                FSDataInputStream stream;
                Iterator<Object> iterator2;
                UnsafeRow emptyUnsafeRow = new UnsafeRow(0);
                if (!this.imageSourceOptions$1.dropInvalid() && this.requiredSchema$1.isEmpty()) {
                    iterator2 = package$.MODULE$.Iterator().apply(Predef$.MODULE$.wrapRefArray((Object[])new UnsafeRow[]{emptyUnsafeRow}));
                } else {
                    Iterator<Row> filteredResult;
                    String origin = file.filePath();
                    Path path = new Path(origin);
                    FileSystem fs = path.getFileSystem(((SerializableConfiguration)this.broadcastedHadoopConf$1.value()).value());
                    stream = fs.open(path);
                    byte[] bytes = ByteStreams.toByteArray((InputStream)stream);
                    Option<Row> resultOpt = GeotiffSchema$.MODULE$.decode(origin, bytes);
                    Iterator<Object> iterator3 = filteredResult = this.imageSourceOptions$1.dropInvalid() ? Option$.MODULE$.option2Iterable(resultOpt).toIterator() : package$.MODULE$.Iterator().apply(Predef$.MODULE$.wrapRefArray((Object[])new Row[]{resultOpt.getOrElse(new Serializable(this, origin){
                        public static final long serialVersionUID = 0L;
                        private final String origin$1;

                        public final Row apply() {
                            return GeotiffSchema$.MODULE$.invalidImageRow(this.origin$1);
                        }
                        {
                            this.origin$1 = origin$1;
                        }
                    })}));
                    if (this.requiredSchema$1.isEmpty()) {
                        iterator2 = filteredResult.map(new Serializable(this, emptyUnsafeRow){
                            public static final long serialVersionUID = 0L;
                            private final UnsafeRow emptyUnsafeRow$1;

                            public final UnsafeRow apply(Row x$1) {
                                return this.emptyUnsafeRow$1;
                            }
                            {
                                this.emptyUnsafeRow$1 = emptyUnsafeRow$1;
                            }
                        });
                    } else {
                        ExpressionEncoder converter = RowEncoder$.MODULE$.apply(this.requiredSchema$1);
                        iterator2 = filteredResult.map(new Serializable(this, converter){
                            public static final long serialVersionUID = 0L;
                            private final ExpressionEncoder converter$1;

                            public final InternalRow apply(Row row) {
                                return this.converter$1.toRow((Object)row);
                            }
                            {
                                this.converter$1 = converter$1;
                            }
                        });
                    }
                }
                return iterator2;
                finally {
                    Closeables.close((Closeable)stream, (boolean)true);
                }
            }
            {
                this.requiredSchema$1 = requiredSchema$1;
                this.broadcastedHadoopConf$1 = broadcastedHadoopConf$1;
                this.imageSourceOptions$1 = imageSourceOptions$1;
            }
        };
    }

    public GeotiffFileFormat() {
        FileFormat.class.$init$((FileFormat)this);
    }
}

