/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.utils;

import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class CRSTransformation {
    public static Point Transform(String sourceEpsgCRSCode, String targetEpsgCRSCode, Point sourceObject) {
        try {
            CoordinateReferenceSystem sourceCRS = CRS.decode((String)sourceEpsgCRSCode);
            CoordinateReferenceSystem targetCRS = CRS.decode((String)targetEpsgCRSCode);
            MathTransform transform2 = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, (boolean)false);
            return (Point)JTS.transform((Geometry)sourceObject, (MathTransform)transform2);
        }
        catch (FactoryException e) {
            e.printStackTrace();
            return null;
        }
        catch (MismatchedDimensionException e) {
            e.printStackTrace();
            return null;
        }
        catch (TransformException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Polygon Transform(String sourceEpsgCRSCode, String targetEpsgCRSCode, Polygon sourceObject) {
        try {
            CoordinateReferenceSystem sourceCRS = CRS.decode((String)sourceEpsgCRSCode);
            CoordinateReferenceSystem targetCRS = CRS.decode((String)targetEpsgCRSCode);
            MathTransform transform2 = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, (boolean)false);
            return (Polygon)JTS.transform((Geometry)sourceObject, (MathTransform)transform2);
        }
        catch (FactoryException e) {
            e.printStackTrace();
            return null;
        }
        catch (MismatchedDimensionException e) {
            e.printStackTrace();
            return null;
        }
        catch (TransformException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Envelope Transform(String sourceEpsgCRSCode, String targetEpsgCRSCode, Envelope sourceObject) {
        try {
            CoordinateReferenceSystem sourceCRS = CRS.decode((String)sourceEpsgCRSCode);
            CoordinateReferenceSystem targetCRS = CRS.decode((String)targetEpsgCRSCode);
            MathTransform transform2 = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, (boolean)false);
            return JTS.transform((Envelope)sourceObject, (MathTransform)transform2);
        }
        catch (FactoryException e) {
            e.printStackTrace();
            return null;
        }
        catch (MismatchedDimensionException e) {
            e.printStackTrace();
            return null;
        }
        catch (TransformException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T extends Geometry> T Transform(String sourceEpsgCRSCode, String targetEpsgCRSCode, T sourceObject) {
        try {
            CoordinateReferenceSystem sourceCRS = CRS.decode((String)sourceEpsgCRSCode);
            CoordinateReferenceSystem targetCRS = CRS.decode((String)targetEpsgCRSCode);
            MathTransform transform2 = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, (boolean)false);
            return (T)JTS.transform(sourceObject, (MathTransform)transform2);
        }
        catch (FactoryException e) {
            e.printStackTrace();
            return null;
        }
        catch (MismatchedDimensionException e) {
            e.printStackTrace();
            return null;
        }
        catch (TransformException e) {
            e.printStackTrace();
            return null;
        }
    }
}

