/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.spatialPartitioning.quadtree;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.sedona.core.enums.GridType;
import org.apache.sedona.core.joinJudgement.DedupParams;
import org.apache.sedona.core.spatialPartitioning.SpatialPartitioner;
import org.apache.sedona.core.spatialPartitioning.quadtree.QuadRectangle;
import org.apache.sedona.core.spatialPartitioning.quadtree.StandardQuadTree;
import org.apache.sedona.core.utils.HalfOpenRectangle;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import scala.Tuple2;

public class QuadTreePartitioner
extends SpatialPartitioner {
    private final StandardQuadTree<? extends Geometry> quadTree;

    public QuadTreePartitioner(StandardQuadTree<? extends Geometry> quadTree) {
        super(GridType.QUADTREE, QuadTreePartitioner.getLeafGrids(quadTree));
        this.quadTree = quadTree;
        this.quadTree.dropElements();
    }

    private static List<Envelope> getLeafGrids(StandardQuadTree<? extends Geometry> quadTree) {
        Objects.requireNonNull(quadTree, "quadTree");
        List<QuadRectangle> zones = quadTree.getLeafZones();
        ArrayList<Envelope> grids = new ArrayList<Envelope>();
        for (QuadRectangle zone : zones) {
            grids.add(zone.getEnvelope());
        }
        return grids;
    }

    @Override
    public <T extends Geometry> Iterator<Tuple2<Integer, T>> placeObject(T spatialObject) throws Exception {
        Objects.requireNonNull(spatialObject, "spatialObject");
        Envelope envelope = spatialObject.getEnvelopeInternal();
        List<QuadRectangle> matchedPartitions = this.quadTree.findZones(new QuadRectangle(envelope));
        Point point = spatialObject instanceof Point ? (Point)spatialObject : null;
        HashSet<Tuple2<Integer, T>> result2 = new HashSet<Tuple2<Integer, T>>();
        for (QuadRectangle rectangle : matchedPartitions) {
            if (point != null && !new HalfOpenRectangle(rectangle.getEnvelope()).contains(point)) continue;
            result2.add(new Tuple2<Integer, T>(rectangle.partitionId, spatialObject));
        }
        return result2.iterator();
    }

    @Override
    @Nullable
    public DedupParams getDedupParams() {
        return new DedupParams(this.grids);
    }

    public int numPartitions() {
        return this.grids.size();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof QuadTreePartitioner)) {
            return false;
        }
        QuadTreePartitioner other = (QuadTreePartitioner)o;
        return other.quadTree.equals(this.quadTree);
    }
}

