/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.spatialPartitioning;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.locationtech.jts.geom.Envelope;

public class HilbertPartitioning
implements Serializable {
    private static final int GRID_RESOLUTION = Short.MAX_VALUE;
    protected int[] splits;
    List<Envelope> grids = new ArrayList<Envelope>();

    public HilbertPartitioning(List<Envelope> samples, Envelope boundary, int partitions) throws Exception {
        int[] hValues = new int[samples.size()];
        for (int i = 0; i < samples.size(); ++i) {
            hValues[i] = HilbertPartitioning.computeHValue(boundary, samples.get(i));
        }
        this.createFromHValues(hValues, partitions);
        Envelope[] gridWithoutID = new Envelope[partitions];
        for (Envelope sample : samples) {
            int partitionID = HilbertPartitioning.gridID(boundary, sample, this.splits);
            Envelope current = gridWithoutID[partitionID];
            if (current == null) {
                gridWithoutID[partitionID] = sample;
                continue;
            }
            gridWithoutID[partitionID] = HilbertPartitioning.updateEnvelope(current, sample);
        }
        for (Envelope envelope : gridWithoutID) {
            this.grids.add(envelope);
        }
    }

    public static int computeHValue(int n, int x, int y) {
        int h = 0;
        for (int s2 = n / 2; s2 > 0; s2 /= 2) {
            int rx = (x & s2) > 0 ? 1 : 0;
            int ry = (y & s2) > 0 ? 1 : 0;
            h += s2 * s2 * (3 * rx ^ ry);
            if (ry != 0) continue;
            if (rx == 1) {
                x = n - 1 - x;
                y = n - 1 - y;
            }
            int t = x;
            x = y;
            y = t;
        }
        return h;
    }

    public static int locationMapping(double axisMin, double axisLocation, double axisMax) {
        Double gridLocation = (axisLocation - axisMin) * 32767.0 / (axisMax - axisMin);
        return gridLocation.intValue();
    }

    public static int gridID(Envelope boundary, Envelope spatialObject, int[] partitionBounds) throws Exception {
        int hValue = HilbertPartitioning.computeHValue(boundary, spatialObject);
        int partition2 = Arrays.binarySearch(partitionBounds, hValue);
        if (partition2 < 0) {
            partition2 = -partition2 - 1;
        }
        return partition2;
    }

    private static int computeHValue(Envelope boundary, Envelope spatialObject) {
        int x = HilbertPartitioning.locationMapping(boundary.getMinX(), boundary.getMaxX(), (spatialObject.getMinX() + spatialObject.getMaxX()) / 2.0);
        int y = HilbertPartitioning.locationMapping(boundary.getMinY(), boundary.getMaxY(), (spatialObject.getMinY() + spatialObject.getMaxY()) / 2.0);
        return HilbertPartitioning.computeHValue(32768, x, y);
    }

    public static Envelope updateEnvelope(Envelope envelope, Envelope spatialObject) throws Exception {
        double minX = Math.min(envelope.getMinX(), spatialObject.getMinX());
        double maxX = Math.max(envelope.getMaxX(), spatialObject.getMaxX());
        double minY = Math.min(envelope.getMinY(), spatialObject.getMinY());
        double maxY = Math.max(envelope.getMaxY(), spatialObject.getMaxY());
        return new Envelope(minX, maxX, minY, maxY);
    }

    protected void createFromHValues(int[] hValues, int partitions) {
        Arrays.sort(hValues);
        this.splits = new int[partitions];
        int maxH = Integer.MAX_VALUE;
        for (int i = 0; i < this.splits.length; ++i) {
            int quantile = (int)((long)(i + 1) * (long)hValues.length / (long)partitions);
            this.splits[i] = quantile == hValues.length ? maxH : hValues[quantile];
        }
    }

    public int[] getPartitionBounds() {
        return this.splits;
    }

    public List<Envelope> getGrids() {
        return this.grids;
    }
}

