/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.showcase;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.sedona.core.enums.FileDataSplitter;
import org.apache.sedona.core.enums.IndexType;
import org.apache.sedona.core.formatMapper.EarthdataHDFPointMapper;
import org.apache.sedona.core.showcase.ScalaEarthdataMapperRunnableExample;
import org.apache.sedona.core.spatialOperator.RangeQuery;
import org.apache.sedona.core.spatialRDD.PointRDD;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.storage.StorageLevel$;
import org.locationtech.jts.geom.Envelope;
import scala.App;
import scala.App$class;
import scala.Function0;
import scala.Predef$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

public final class ScalaEarthdataMapperRunnableExample$
implements App {
    public static final ScalaEarthdataMapperRunnableExample$ MODULE$;
    private final SparkConf conf;
    private final SparkContext sc;
    private final String InputLocation;
    private final FileDataSplitter splitter;
    private final IndexType indexType;
    private final Envelope queryEnvelope;
    private final int numPartitions;
    private final int loopTimes;
    private final int HDFIncrement;
    private final int HDFOffset;
    private final String HDFRootGroupName;
    private final String HDFDataVariableName;
    private final String urlPrefix;
    private final String[] HDFDataVariableList;
    private final long executionStart;
    private String[] scala$App$$_args;
    private final ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;

    static {
        new ScalaEarthdataMapperRunnableExample$();
    }

    @Override
    public long executionStart() {
        return this.executionStart;
    }

    @Override
    public String[] scala$App$$_args() {
        return this.scala$App$$_args;
    }

    @Override
    public void scala$App$$_args_$eq(String[] x$1) {
        this.scala$App$$_args = x$1;
    }

    @Override
    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return this.scala$App$$initCode;
    }

    @Override
    public void scala$App$_setter_$executionStart_$eq(long x$1) {
        this.executionStart = x$1;
    }

    @Override
    public void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer x$1) {
        this.scala$App$$initCode = x$1;
    }

    @Override
    public String[] args() {
        return App$class.args(this);
    }

    @Override
    public void delayedInit(Function0<BoxedUnit> body2) {
        App$class.delayedInit(this, body2);
    }

    @Override
    public void main(String[] args) {
        App$class.main(this, args);
    }

    public SparkConf conf() {
        return this.conf;
    }

    public SparkContext sc() {
        return this.sc;
    }

    public String InputLocation() {
        return this.InputLocation;
    }

    public FileDataSplitter splitter() {
        return this.splitter;
    }

    public IndexType indexType() {
        return this.indexType;
    }

    public Envelope queryEnvelope() {
        return this.queryEnvelope;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public int loopTimes() {
        return this.loopTimes;
    }

    public int HDFIncrement() {
        return this.HDFIncrement;
    }

    public int HDFOffset() {
        return this.HDFOffset;
    }

    public String HDFRootGroupName() {
        return this.HDFRootGroupName;
    }

    public String HDFDataVariableName() {
        return this.HDFDataVariableName;
    }

    public String urlPrefix() {
        return this.urlPrefix;
    }

    public String[] HDFDataVariableList() {
        return this.HDFDataVariableList;
    }

    public void testSpatialRangeQuery() {
        EarthdataHDFPointMapper earthdataHDFPoint = new EarthdataHDFPointMapper(this.HDFIncrement(), this.HDFOffset(), this.HDFRootGroupName(), this.HDFDataVariableList(), this.HDFDataVariableName(), this.urlPrefix());
        PointRDD spatialRDD = new PointRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sc()), this.InputLocation(), Predef$.MODULE$.int2Integer(this.numPartitions()), earthdataHDFPoint, StorageLevel$.MODULE$.MEMORY_ONLY());
        for (int i = 0; i < this.loopTimes(); ++i) {
            long resultSize = 0L;
            resultSize = RangeQuery.SpatialRangeQuery(spatialRDD, this.queryEnvelope(), false, false).count();
        }
    }

    public void testSpatialRangeQueryUsingIndex() {
        EarthdataHDFPointMapper earthdataHDFPoint = new EarthdataHDFPointMapper(this.HDFIncrement(), this.HDFOffset(), this.HDFRootGroupName(), this.HDFDataVariableList(), this.HDFDataVariableName(), this.urlPrefix());
        PointRDD spatialRDD = new PointRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sc()), this.InputLocation(), Predef$.MODULE$.int2Integer(this.numPartitions()), earthdataHDFPoint, StorageLevel$.MODULE$.MEMORY_ONLY());
        spatialRDD.buildIndex(IndexType.RTREE, false);
        for (int i = 0; i < this.loopTimes(); ++i) {
            long resultSize = 0L;
            resultSize = RangeQuery.SpatialRangeQuery(spatialRDD, this.queryEnvelope(), false, true).count();
        }
    }

    public final void delayedEndpoint$org$apache$sedona$core$showcase$ScalaEarthdataMapperRunnableExample$1() {
        this.conf = new SparkConf().setAppName("EarthdataMapperRunnableExample").setMaster("local[2]");
        this.sc = new SparkContext(this.conf());
        Logger.getLogger((String)"org").setLevel(Level.WARN);
        Logger.getLogger((String)"akka").setLevel(Level.WARN);
        this.InputLocation = new StringBuilder().append((Object)System.getProperty("user.dir")).append((Object)"/src/test/resources/modis/modis.csv").toString();
        this.splitter = FileDataSplitter.CSV;
        this.indexType = IndexType.RTREE;
        this.queryEnvelope = new Envelope(-90.01, -80.01, 30.01, 40.01);
        this.numPartitions = 5;
        this.loopTimes = 1;
        this.HDFIncrement = 5;
        this.HDFOffset = 2;
        this.HDFRootGroupName = "MOD_Swath_LST";
        this.HDFDataVariableName = "LST";
        this.urlPrefix = new StringBuilder().append((Object)System.getProperty("user.dir")).append((Object)"/src/test/resources/modis/").toString();
        this.HDFDataVariableList = (String[])((Object[])new String[]{"LST", "QC", "Error_LST", "Emis_31", "Emis_32"});
        this.testSpatialRangeQuery();
        this.testSpatialRangeQueryUsingIndex();
        this.sc().stop();
        System.out.println("All Earthdata DEMOs passed!");
    }

    private ScalaEarthdataMapperRunnableExample$() {
        MODULE$ = this;
        App$class.$init$(this);
        this.delayedInit(new ScalaEarthdataMapperRunnableExample.delayedInit.body(this));
    }
}

