/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.formatMapper.shapefileParser.shapes;

import java.io.DataInputStream;
import java.io.IOException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.dbf.DbfParseUtil;
import org.apache.sedona.core.formatMapper.shapefileParser.shapes.ShapeKey;

public class DbfFileReader
extends RecordReader<ShapeKey, String> {
    DbfParseUtil dbfParser = null;
    private FSDataInputStream inputStream = null;
    private String value = null;
    private ShapeKey key = null;
    private int id = 0;

    public void initialize(InputSplit split2, TaskAttemptContext context) throws IOException, InterruptedException {
        FileSplit fileSplit = (FileSplit)split2;
        Path inputPath = fileSplit.getPath();
        FileSystem fileSys = inputPath.getFileSystem(context.getConfiguration());
        this.inputStream = fileSys.open(inputPath);
        this.dbfParser = new DbfParseUtil();
        this.dbfParser.parseFileHead((DataInputStream)this.inputStream);
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        String curbytes = this.dbfParser.parsePrimitiveRecord((DataInputStream)this.inputStream);
        if (curbytes == null) {
            this.value = null;
            return false;
        }
        this.value = curbytes;
        this.key = new ShapeKey();
        this.key.setIndex(this.id++);
        return true;
    }

    public ShapeKey getCurrentKey() throws IOException, InterruptedException {
        return this.key;
    }

    public String getCurrentValue() throws IOException, InterruptedException {
        return this.value;
    }

    public float getProgress() throws IOException, InterruptedException {
        return this.dbfParser.getProgress();
    }

    public void close() throws IOException {
        this.inputStream.close();
    }
}

