/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.shp;

import com.esotericsoftware.kryo.io.Input;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.shp.ShapeParser;
import org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.shp.ShapeReader;
import org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.shp.ShapeReaderFactory;
import org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.shp.ShapeType;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class ShapeSerde {
    private static final int POINT_LENGTH = 17;

    public static byte[] serialize(Geometry geometry) {
        if (geometry instanceof Point) {
            return ShapeSerde.serialize((Point)geometry);
        }
        if (geometry instanceof MultiPoint) {
            return ShapeSerde.serialize((MultiPoint)geometry);
        }
        if (geometry instanceof LineString) {
            return ShapeSerde.serialize((LineString)geometry);
        }
        if (geometry instanceof MultiLineString) {
            return ShapeSerde.serialize((MultiLineString)geometry);
        }
        if (geometry instanceof Polygon) {
            return ShapeSerde.serialize((Polygon)geometry);
        }
        if (geometry instanceof MultiPolygon) {
            return ShapeSerde.serialize((MultiPolygon)geometry);
        }
        throw new UnsupportedOperationException("Geometry type is not supported: " + geometry.getClass().getSimpleName());
    }

    public static Geometry deserialize(Input input2, GeometryFactory factory) {
        ShapeReader reader = ShapeReaderFactory.fromInput(input2);
        ShapeType type = ShapeType.getType(reader.readByte());
        ShapeParser parser = type.getParser(factory);
        return parser.parseShape(reader);
    }

    public static Geometry deserialize(byte[] input2, GeometryFactory factory) {
        ShapeReader reader = ShapeReaderFactory.fromByteBuffer(ByteBuffer.wrap(input2));
        ShapeType type = ShapeType.getType(reader.readByte());
        ShapeParser parser = type.getParser(factory);
        return parser.parseShape(reader);
    }

    private static byte[] serialize(Point point) {
        ByteBuffer buffer = ShapeSerde.newBuffer(17);
        ShapeSerde.putType(buffer, ShapeType.POINT);
        buffer.putDouble(point.getX());
        buffer.putDouble(point.getY());
        return buffer.array();
    }

    private static void putType(ByteBuffer buffer, ShapeType type) {
        buffer.put((byte)type.getId());
    }

    private static byte[] serialize(MultiPoint multiPoint) {
        int numPoints = multiPoint.getNumPoints();
        ByteBuffer buffer = ShapeSerde.newBuffer(ShapeSerde.calculateBufferSize(multiPoint));
        ShapeSerde.putType(buffer, ShapeType.MULTIPOINT);
        buffer.position(buffer.position() + 32);
        buffer.putInt(numPoints);
        for (int i = 0; i < numPoints; ++i) {
            Point point = (Point)multiPoint.getGeometryN(i);
            buffer.putDouble(point.getX());
            buffer.putDouble(point.getY());
        }
        return buffer.array();
    }

    private static int calculateBufferSize(MultiPoint multiPoint) {
        return 37 + multiPoint.getNumPoints() * 2 * 8;
    }

    private static byte[] serialize(LineString lineString) {
        int numPoints = lineString.getNumPoints();
        ByteBuffer buffer = ShapeSerde.newBuffer(ShapeSerde.calculateBufferSize(numPoints, 1));
        ShapeSerde.putHeader(buffer, ShapeType.POLYLINE, numPoints, 1);
        buffer.putInt(0);
        ShapeSerde.putPoints(buffer, lineString);
        return buffer.array();
    }

    private static int calculateBufferSize(int numPoints, int numParts) {
        return 41 + numParts * 4 + numPoints * 2 * 8;
    }

    private static void putHeader(ByteBuffer buffer, ShapeType type, int numPoints, int numParts) {
        ShapeSerde.putType(buffer, type);
        buffer.position(buffer.position() + 32);
        buffer.putInt(numParts);
        buffer.putInt(numPoints);
    }

    private static byte[] serialize(MultiLineString multiLineString) {
        int i;
        int numPoints = multiLineString.getNumPoints();
        int numParts = multiLineString.getNumGeometries();
        ByteBuffer buffer = ShapeSerde.newBuffer(ShapeSerde.calculateBufferSize(numPoints, numParts));
        ShapeSerde.putHeader(buffer, ShapeType.POLYLINE, numPoints, numParts);
        int offset = 0;
        for (i = 0; i < numParts; ++i) {
            buffer.putInt(offset);
            offset += multiLineString.getGeometryN(i).getNumPoints();
        }
        for (i = 0; i < numParts; ++i) {
            ShapeSerde.putPoints(buffer, (LineString)multiLineString.getGeometryN(i));
        }
        return buffer.array();
    }

    private static byte[] serialize(Polygon polygon) {
        int numRings = polygon.getNumInteriorRing() + 1;
        int numPoints = polygon.getNumPoints();
        ByteBuffer buffer = ShapeSerde.newBuffer(ShapeSerde.calculateBufferSize(numPoints, numRings));
        ShapeSerde.putHeader(buffer, ShapeType.POLYGON, numPoints, numRings);
        ShapeSerde.putRingOffsets(buffer, polygon, 0);
        ShapeSerde.putPolygonPoints(buffer, polygon);
        return buffer.array();
    }

    private static int putRingOffsets(ByteBuffer buffer, Polygon polygon, int initialOffset) {
        int offset = initialOffset;
        int numRings = polygon.getNumInteriorRing() + 1;
        buffer.putInt(offset);
        offset += polygon.getExteriorRing().getNumPoints();
        for (int i = 0; i < numRings - 1; ++i) {
            buffer.putInt(offset);
            offset += polygon.getInteriorRingN(i).getNumPoints();
        }
        return offset;
    }

    private static byte[] serialize(MultiPolygon multiPolygon) {
        Polygon polygon;
        int i;
        int numPolygons = multiPolygon.getNumGeometries();
        int numPoints = multiPolygon.getNumPoints();
        int numRings = 0;
        for (int i2 = 0; i2 < numPolygons; ++i2) {
            Polygon polygon2 = (Polygon)multiPolygon.getGeometryN(i2);
            numRings += polygon2.getNumInteriorRing() + 1;
        }
        ByteBuffer buffer = ShapeSerde.newBuffer(ShapeSerde.calculateBufferSize(numPoints, numRings));
        ShapeSerde.putHeader(buffer, ShapeType.POLYGON, numPoints, numRings);
        int offset = 0;
        for (i = 0; i < numPolygons; ++i) {
            polygon = (Polygon)multiPolygon.getGeometryN(i);
            offset = ShapeSerde.putRingOffsets(buffer, polygon, offset);
        }
        for (i = 0; i < numPolygons; ++i) {
            polygon = (Polygon)multiPolygon.getGeometryN(i);
            ShapeSerde.putPolygonPoints(buffer, polygon);
        }
        return buffer.array();
    }

    private static void putPolygonPoints(ByteBuffer buffer, Polygon polygon) {
        ShapeSerde.putPoints(buffer, polygon.getExteriorRing());
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            ShapeSerde.putPoints(buffer, polygon.getInteriorRingN(i));
        }
    }

    private static void putPoints(ByteBuffer buffer, LineString geometry) {
        int numPoints = geometry.getNumPoints();
        for (int i = 0; i < numPoints; ++i) {
            Point point = geometry.getPointN(i);
            buffer.putDouble(point.getX());
            buffer.putDouble(point.getY());
        }
    }

    private static ByteBuffer newBuffer(int size2) {
        return ByteBuffer.allocate(size2).order(ByteOrder.LITTLE_ENDIAN);
    }
}

