/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.shp;

import com.esotericsoftware.kryo.io.Input;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.shp.ShapeReader;

public class ShapeReaderFactory {
    public static ShapeReader fromByteBuffer(ByteBuffer buffer) {
        final ByteBuffer leBuffer = buffer.slice().order(ByteOrder.LITTLE_ENDIAN);
        return new ShapeReader(){

            @Override
            public int readInt() {
                return leBuffer.getInt();
            }

            @Override
            public double readDouble() {
                return leBuffer.getDouble();
            }

            @Override
            public byte readByte() {
                return leBuffer.get();
            }

            @Override
            public void skip(int numBytes) {
                leBuffer.position(leBuffer.position() + numBytes);
            }
        };
    }

    public static ShapeReader fromInput(final Input input2) {
        return new ShapeReader(){

            @Override
            public int readInt() {
                return ShapeReaderFactory.toByteBuffer(input2, 4).getInt();
            }

            @Override
            public double readDouble() {
                return ShapeReaderFactory.toByteBuffer(input2, 8).getDouble();
            }

            @Override
            public byte readByte() {
                return input2.readByte();
            }

            @Override
            public void skip(int numBytes) {
                input2.skip(numBytes);
            }
        };
    }

    private static ByteBuffer toByteBuffer(Input input2, int numBytes) {
        byte[] bytes = new byte[numBytes];
        input2.read(bytes);
        return ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
    }
}

