/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.expressions.simplify;

import java.io.Serializable;
import org.apache.sedona.core.geometryObjects.Circle;
import org.apache.spark.sql.sedona_sql.expressions.simplify.CircleSimplifier$;
import org.apache.spark.sql.sedona_sql.expressions.simplify.LinestringSimplifier$;
import org.apache.spark.sql.sedona_sql.expressions.simplify.PolygonSimplifier$;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class GeometryCollectionSimplifier$ {
    public static GeometryCollectionSimplifier$ MODULE$;
    private final GeometryFactory geometryFactory;

    static {
        new GeometryCollectionSimplifier$();
    }

    private GeometryFactory geometryFactory() {
        return this.geometryFactory;
    }

    public Geometry simplify(GeometryCollection geom, boolean preserveCollapsed, double epsilon) {
        GeometryCollection geometryCollection;
        int numberOfGeometries = geom.getNumGeometries();
        Geometry[] geometries = (Geometry[])((TraversableOnce)((TraversableLike)((TraversableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numberOfGeometries).map((Function1<Object, Geometry> & Serializable & scala.Serializable)x$1 -> geom.getGeometryN(BoxesRunTime.unboxToInt(x$1)), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1<Geometry, Geometry> & Serializable & scala.Serializable)x0$1 -> {
            Geometry geometry;
            Geometry geometry2 = x0$1;
            if (geometry2 instanceof Circle) {
                Circle circle = (Circle)geometry2;
                geometry = CircleSimplifier$.MODULE$.simplify(circle, preserveCollapsed, epsilon);
            } else if (geometry2 instanceof LineString) {
                LineString lineString = (LineString)geometry2;
                geometry = LinestringSimplifier$.MODULE$.simplify(lineString, epsilon, preserveCollapsed);
            } else if (geometry2 instanceof Point) {
                Point point = (Point)geometry2;
                geometry = point;
            } else if (geometry2 instanceof Polygon) {
                Polygon polygon = (Polygon)geometry2;
                geometry = PolygonSimplifier$.MODULE$.simplify(polygon, preserveCollapsed, epsilon);
            } else if (geometry2 instanceof GeometryCollection) {
                GeometryCollection geometryCollection = (GeometryCollection)geometry2;
                geometry = MODULE$.simplify(geometryCollection, preserveCollapsed, epsilon);
            } else {
                geometry = null;
            }
            return geometry;
        }, IndexedSeq$.MODULE$.canBuildFrom())).filter((Function1<Geometry, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(GeometryCollectionSimplifier$.$anonfun$simplify$3(x$1)))).toArray(ClassTag$.MODULE$.apply(Geometry.class));
        String[] distinctGeometries = (String[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])geometries)).map((Function1<Geometry, String> & Serializable & scala.Serializable)x$2 -> x$2.getGeometryType(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).distinct();
        if (distinctGeometries.length == 1) {
            MultiLineString multiLineString;
            String string = (String)new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])distinctGeometries)).head();
            if ("LineString".equals(string)) {
                multiLineString = this.geometryFactory().createMultiLineString((LineString[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])geometries)).map((Function1<Geometry, LineString> & Serializable & scala.Serializable)x -> (LineString)x, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LineString.class))));
            } else if ("Polygon".equals(string)) {
                multiLineString = this.geometryFactory().createMultiPolygon((Polygon[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])geometries)).map((Function1<Geometry, Polygon> & Serializable & scala.Serializable)x -> (Polygon)x, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Polygon.class))));
            } else if ("Point".equals(string)) {
                multiLineString = this.geometryFactory().createMultiPoint((Point[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])geometries)).map((Function1<Geometry, Point> & Serializable & scala.Serializable)x -> (Point)x, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Point.class))));
            } else {
                throw new MatchError((Object)string);
            }
            geometryCollection = multiLineString;
        } else {
            geometryCollection = this.geometryFactory().createGeometryCollection(geometries);
        }
        return geometryCollection;
    }

    public static final /* synthetic */ boolean $anonfun$simplify$3(Geometry x$1) {
        return x$1 != null;
    }

    private GeometryCollectionSimplifier$() {
        MODULE$ = this;
        this.geometryFactory = new GeometryFactory();
    }
}

