/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.sql.utils;

import java.io.Serializable;
import org.apache.sedona.core.spatialRDD.SpatialRDD;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.sedona_sql.UDT.GeometryUDT$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.locationtech.jts.geom.Geometry;
import scala.Array$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class Adapter$ {
    public static Adapter$ MODULE$;

    static {
        new Adapter$();
    }

    public SpatialRDD<Geometry> toSpatialRdd(Dataset<Row> dataFrame, String geometryFieldName) {
        SpatialRDD<Geometry> spatialRDD;
        if (dataFrame.schema().size() == 1) {
            spatialRDD = this.toSpatialRdd(dataFrame, 0, (Seq<String>)Nil$.MODULE$);
        } else {
            List fieldList = (List)dataFrame.schema().toList().map((Function1 & Serializable & scala.Serializable)f -> f.name(), List$.MODULE$.canBuildFrom());
            spatialRDD = this.toSpatialRdd(dataFrame, geometryFieldName, (Seq<String>)((Seq)fieldList.filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)Adapter$.$anonfun$toSpatialRdd$2(geometryFieldName, p)))));
        }
        return spatialRDD;
    }

    public SpatialRDD<Geometry> toSpatialRdd(Dataset<Row> dataFrame, String geometryFieldName, Seq<String> fieldNames) {
        SpatialRDD<Geometry> spatialRDD = new SpatialRDD<Geometry>();
        spatialRDD.rawSpatialRDD = this.toRdd(dataFrame, geometryFieldName).toJavaRDD();
        spatialRDD.fieldNames = fieldNames != null && fieldNames.nonEmpty() ? JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList(fieldNames) : null;
        return spatialRDD;
    }

    private RDD<Geometry> toRdd(Dataset<Row> dataFrame, String geometryFieldName) {
        List fieldList = (List)dataFrame.schema().toList().map((Function1 & Serializable & scala.Serializable)f -> f.name(), List$.MODULE$.canBuildFrom());
        int geomColId = fieldList.indexOf((Object)geometryFieldName);
        Predef$.MODULE$.assert(geomColId >= 0);
        return this.toRdd(dataFrame, geomColId);
    }

    public SpatialRDD<Geometry> toSpatialRdd(Dataset<Row> dataFrame, int geometryColId, Seq<String> fieldNames) {
        SpatialRDD<Geometry> spatialRDD = new SpatialRDD<Geometry>();
        spatialRDD.rawSpatialRDD = this.toRdd(dataFrame, geometryColId).toJavaRDD();
        spatialRDD.fieldNames = fieldNames.nonEmpty() ? JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList(fieldNames) : null;
        return spatialRDD;
    }

    public SpatialRDD<Geometry> toSpatialRdd(Dataset<Row> dataFrame, int geometryColId) {
        SpatialRDD<Geometry> spatialRDD;
        if (dataFrame.schema().size() == 1) {
            spatialRDD = this.toSpatialRdd(dataFrame, 0, (Seq<String>)Nil$.MODULE$);
        } else {
            List fieldList = (List)dataFrame.schema().toList().map((Function1 & Serializable & scala.Serializable)f -> f.name(), List$.MODULE$.canBuildFrom());
            String geometryFieldName = (String)fieldList.apply(geometryColId);
            spatialRDD = this.toSpatialRdd(dataFrame, geometryColId, (Seq<String>)((Seq)fieldList.filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)Adapter$.$anonfun$toSpatialRdd$4(geometryFieldName, p)))));
        }
        return spatialRDD;
    }

    public <T extends Geometry> Dataset<Row> toDf(SpatialRDD<T> spatialRDD, SparkSession sparkSession) {
        if (spatialRDD.fieldNames != null) {
            return this.toDf(spatialRDD, (Seq<String>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(spatialRDD.fieldNames).asScala()).toList(), sparkSession);
        }
        return this.toDf(spatialRDD, null, sparkSession);
    }

    public <T extends Geometry> Dataset<Row> toDf(SpatialRDD<T> spatialRDD, Seq<String> fieldNames, SparkSession sparkSession) {
        RDD rowRdd = spatialRDD.rawSpatialRDD.rdd().map((Function1 & Serializable & scala.Serializable)geom -> {
            Row row;
            Object userData = geom.getUserData();
            Geometry geomWithoutUserData = geom.copy();
            geomWithoutUserData.setUserData(null);
            if (userData != null) {
                Geometry geometry = geomWithoutUserData;
                row = Row$.MODULE$.fromSeq((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)userData).split("\t", -1))).$plus$colon((Object)geometry, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())));
            } else {
                row = Row$.MODULE$.fromSeq((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Geometry[]{geom})));
            }
            return row;
        }, ClassTag$.MODULE$.apply(Row.class));
        Seq cols = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("geometry", (DataType)GeometryUDT$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}));
        if (fieldNames != null && fieldNames.nonEmpty()) {
            cols = (Seq)cols.$plus$plus((GenTraversableOnce)fieldNames.map((Function1 & Serializable & scala.Serializable)f -> new StructField(f, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        }
        StructType schema = StructType$.MODULE$.apply(cols);
        return sparkSession.createDataFrame(rowRdd, schema);
    }

    public Dataset<Row> toDf(JavaPairRDD<Geometry, Geometry> spatialPairRDD, SparkSession sparkSession) {
        return this.toDf(spatialPairRDD, null, null, sparkSession);
    }

    public Dataset<Row> toDf(JavaPairRDD<Geometry, Geometry> spatialPairRDD, Seq<String> leftFieldnames, Seq<String> rightFieldNames, SparkSession sparkSession) {
        RDD rowRdd = spatialPairRDD.rdd().map((Function1 & Serializable & scala.Serializable)f -> {
            Tuple2<Seq<Geometry>, Seq<String>> left = MODULE$.getGeomAndFields((Geometry)f._1(), leftFieldnames);
            Tuple2<Seq<Geometry>, Seq<String>> right = MODULE$.getGeomAndFields((Geometry)f._2(), rightFieldNames);
            return Row$.MODULE$.fromSeq((Seq)((TraversableLike)((TraversableLike)((TraversableLike)left._1()).$plus$plus((GenTraversableOnce)left._2(), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)right._1(), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)right._2(), Seq$.MODULE$.canBuildFrom()));
        }, ClassTag$.MODULE$.apply(Row.class));
        Seq cols = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("leftgeometry", (DataType)GeometryUDT$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}));
        if (leftFieldnames != null && leftFieldnames.nonEmpty()) {
            cols = (Seq)cols.$plus$plus((GenTraversableOnce)leftFieldnames.map((Function1 & Serializable & scala.Serializable)fName -> new StructField(fName, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        }
        cols = (Seq)cols.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("rightgeometry", (DataType)GeometryUDT$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})), Seq$.MODULE$.canBuildFrom());
        if (rightFieldNames != null && rightFieldNames.nonEmpty()) {
            cols = (Seq)cols.$plus$plus((GenTraversableOnce)rightFieldNames.map((Function1 & Serializable & scala.Serializable)fName -> new StructField(fName, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        }
        StructType schema = StructType$.MODULE$.apply(cols);
        return sparkSession.createDataFrame(rowRdd, schema);
    }

    private RDD<Geometry> toRdd(Dataset<Row> dataFrame, int geometryColId) {
        return dataFrame.rdd().map((Function1 & Serializable & scala.Serializable)f -> {
            void var2_2;
            Geometry geometry = (Geometry)f.get(geometryColId);
            int fieldSize = f.size();
            ObjectRef userData = ObjectRef.create(null);
            if (fieldSize > 1) {
                userData.elem = "";
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), geometryColId).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    userData$1.elem = new StringBuilder(0).append((String)userData$1.elem).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(f.get(i)), "\t")).toString();
                });
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(geometryColId + 1), f.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    userData$1.elem = new StringBuilder(0).append((String)userData$1.elem).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(f.get(i)), "\t")).toString();
                });
                userData.elem = (String)new StringOps(Predef$.MODULE$.augmentString((String)userData.elem)).dropRight(1);
            }
            geometry.setUserData((String)userData.elem);
            return var2_2;
        }, ClassTag$.MODULE$.apply(Geometry.class));
    }

    private Tuple2<Seq<Geometry>, Seq<String>> getGeomAndFields(Geometry geom, Seq<String> fieldNames) {
        Tuple2 tuple2;
        if (fieldNames != null && fieldNames.nonEmpty()) {
            String userData = String.valueOf((String)geom.getUserData());
            String[] fields = userData.split("\t");
            Geometry geomWithoutUserData = geom.copy();
            geomWithoutUserData.setUserData(null);
            tuple2 = new Tuple2((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Geometry[]{geomWithoutUserData})), (Object)Predef$.MODULE$.wrapRefArray((Object[])fields));
        } else {
            tuple2 = new Tuple2((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Geometry[]{geom})), (Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
        }
        return tuple2;
    }

    public static final /* synthetic */ boolean $anonfun$toSpatialRdd$2(String geometryFieldName$1, String p) {
        return !p.equalsIgnoreCase(geometryFieldName$1);
    }

    public static final /* synthetic */ boolean $anonfun$toSpatialRdd$4(String geometryFieldName$2, String p) {
        return !p.equalsIgnoreCase(geometryFieldName$2);
    }

    private Adapter$() {
        MODULE$ = this;
    }
}

