/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.spatialPartitioning;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Envelope;

public class EqualPartitioning
implements Serializable {
    List<Envelope> grids = new ArrayList<Envelope>();

    public EqualPartitioning(Envelope boundary, int partitions) {
        Double root = Math.sqrt(partitions);
        int partitionsAxis = root.intValue();
        double intervalX = (boundary.getMaxX() - boundary.getMinX()) / (double)partitionsAxis;
        double intervalY = (boundary.getMaxY() - boundary.getMinY()) / (double)partitionsAxis;
        for (int i = 0; i < partitionsAxis; ++i) {
            for (int j = 0; j < partitionsAxis; ++j) {
                Envelope grid = new Envelope(boundary.getMinX() + intervalX * (double)i, boundary.getMinX() + intervalX * (double)(i + 1), boundary.getMinY() + intervalY * (double)j, boundary.getMinY() + intervalY * (double)(j + 1));
                this.grids.add(grid);
            }
        }
    }

    public List<Envelope> getGrids() {
        return this.grids;
    }
}

