/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.strategy.join;

import org.apache.sedona.core.enums.JoinSparitionDominantSide;
import org.apache.sedona.core.spatialOperator.JoinQuery;
import org.apache.sedona.core.spatialRDD.SpatialRDD;
import org.apache.sedona.core.utils.SedonaConf;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.BindReferences$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeRowJoiner$;
import org.apache.spark.sql.catalyst.expressions.codegen.Predicate;
import org.apache.spark.sql.catalyst.expressions.codegen.UnsafeRowJoiner;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.sedona_sql.strategy.join.TraitJoinQueryBase;
import org.apache.spark.sql.sedona_sql.strategy.join.TraitJoinQueryExec;
import org.apache.spark.sql.sedona_sql.strategy.join.TraitJoinQueryExec$;
import org.locationtech.jts.geom.Geometry;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public abstract class TraitJoinQueryExec$class {
    public static Function1 org$apache$spark$sql$sedona_sql$strategy$join$TraitJoinQueryExec$$boundCondition(SparkPlan $this) {
        Object object;
        if (((TraitJoinQueryExec)$this).extraCondition().isDefined()) {
            Predicate predicate = $this.newPredicate((Expression)((TraitJoinQueryExec)$this).extraCondition().get(), (Seq)((TraitJoinQueryExec)$this).left().output().$plus$plus((GenTraversableOnce)((TraitJoinQueryExec)$this).right().output(), Seq$.MODULE$.canBuildFrom()));
            object = new Serializable($this, predicate){
                public static final long serialVersionUID = 0L;
                private final Predicate eta$0$1$1;

                public final boolean apply(InternalRow r) {
                    return this.eta$0$1$1.eval(r);
                }
                {
                    this.eta$0$1$1 = eta$0$1$1;
                }
            };
        } else {
            object = new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(InternalRow r) {
                    return true;
                }
            };
        }
        return object;
    }

    public static Seq output(SparkPlan $this) {
        return (Seq)((TraitJoinQueryExec)$this).left().output().$plus$plus((GenTraversableOnce)((TraitJoinQueryExec)$this).right().output(), Seq$.MODULE$.canBuildFrom());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RDD doExecute(SparkPlan $this) {
        Tuple2 tuple22;
        Expression boundLeftShape = BindReferences$.MODULE$.bindReference(((TraitJoinQueryExec)$this).leftShape(), package$.MODULE$.AttributeSeq(((TraitJoinQueryExec)$this).left().output()), BindReferences$.MODULE$.bindReference$default$3());
        Expression boundRightShape = BindReferences$.MODULE$.bindReference(((TraitJoinQueryExec)$this).rightShape(), package$.MODULE$.AttributeSeq(((TraitJoinQueryExec)$this).right().output()), BindReferences$.MODULE$.bindReference$default$3());
        RDD leftResultsRaw = ((TraitJoinQueryExec)$this).left().execute();
        RDD rightResultsRaw = ((TraitJoinQueryExec)$this).right().execute();
        SedonaConf sedonaConf = new SedonaConf($this.sparkContext().conf());
        Tuple2<SpatialRDD<Geometry>, SpatialRDD<Geometry>> tuple2 = ((TraitJoinQueryBase)$this).toSpatialRddPair((RDD<UnsafeRow>)leftResultsRaw, boundLeftShape, (RDD<UnsafeRow>)rightResultsRaw, boundRightShape);
        if (tuple2 == null) throw new MatchError(tuple2);
        SpatialRDD leftShapes2 = (SpatialRDD)tuple2._1();
        SpatialRDD rightShapes2 = (SpatialRDD)tuple2._2();
        Tuple2 tuple23 = tuple22 = new Tuple2((Object)leftShapes2, (Object)rightShapes2);
        SpatialRDD leftShapes = (SpatialRDD)tuple23._1();
        SpatialRDD rightShapes = (SpatialRDD)tuple23._2();
        if (BoxesRunTime.equalsNumObject((Number)sedonaConf.getJoinApproximateTotalCount(), (Object)BoxesRunTime.boxToInteger((int)-1))) {
            JoinSparitionDominantSide joinSparitionDominantSide = sedonaConf.getJoinSparitionDominantSide();
            JoinSparitionDominantSide joinSparitionDominantSide2 = JoinSparitionDominantSide.LEFT;
            if (!(joinSparitionDominantSide != null ? !joinSparitionDominantSide.equals(joinSparitionDominantSide2) : joinSparitionDominantSide2 != null)) {
                leftShapes.analyze();
                sedonaConf.setJoinApproximateTotalCount(Predef$.MODULE$.long2Long(leftShapes.approximateTotalCount));
                sedonaConf.setDatasetBoundary(leftShapes.boundaryEnvelope);
            } else {
                rightShapes.analyze();
                sedonaConf.setJoinApproximateTotalCount(Predef$.MODULE$.long2Long(rightShapes.approximateTotalCount));
                sedonaConf.setDatasetBoundary(rightShapes.boundaryEnvelope);
            }
        }
        $this.log().info(new StringBuilder().append((Object)"[SedonaSQL] Number of partitions on the left: ").append((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])leftResultsRaw.partitions()).size())).toString());
        $this.log().info(new StringBuilder().append((Object)"[SedonaSQL] Number of partitions on the right: ").append((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])rightResultsRaw.partitions()).size())).toString());
        int numPartitions = -1;
        try {
            JoinSparitionDominantSide joinSparitionDominantSide = sedonaConf.getJoinSparitionDominantSide();
            JoinSparitionDominantSide joinSparitionDominantSide3 = JoinSparitionDominantSide.LEFT;
            if (!(joinSparitionDominantSide != null ? !joinSparitionDominantSide.equals(joinSparitionDominantSide3) : joinSparitionDominantSide3 != null)) {
                numPartitions = BoxesRunTime.equalsNumObject((Number)sedonaConf.getFallbackPartitionNum(), (Object)BoxesRunTime.boxToInteger((int)-1)) ? ((TraitJoinQueryExec)$this).joinPartitionNumOptimizer(leftShapes.rawSpatialRDD.partitions().size(), rightShapes.rawSpatialRDD.partitions().size(), leftShapes.approximateTotalCount) : Predef$.MODULE$.Integer2int(sedonaConf.getFallbackPartitionNum());
                ((TraitJoinQueryBase)$this).doSpatialPartitioning((SpatialRDD<Geometry>)leftShapes, (SpatialRDD<Geometry>)rightShapes, Predef$.MODULE$.int2Integer(numPartitions), sedonaConf);
            } else {
                if (BoxesRunTime.equalsNumObject((Number)sedonaConf.getFallbackPartitionNum(), (Object)BoxesRunTime.boxToInteger((int)-1))) {
                    numPartitions = rightShapes.rawSpatialRDD.partitions().size();
                    numPartitions = ((TraitJoinQueryExec)$this).joinPartitionNumOptimizer(rightShapes.rawSpatialRDD.partitions().size(), leftShapes.rawSpatialRDD.partitions().size(), rightShapes.approximateTotalCount);
                } else {
                    numPartitions = Predef$.MODULE$.Integer2int(sedonaConf.getFallbackPartitionNum());
                }
                ((TraitJoinQueryBase)$this).doSpatialPartitioning((SpatialRDD<Geometry>)rightShapes, (SpatialRDD<Geometry>)leftShapes, Predef$.MODULE$.int2Integer(numPartitions), sedonaConf);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Predef$.MODULE$.print((Object)illegalArgumentException.getMessage());
            JoinSparitionDominantSide joinSparitionDominantSide = sedonaConf.getJoinSparitionDominantSide();
            JoinSparitionDominantSide joinSparitionDominantSide4 = JoinSparitionDominantSide.LEFT;
            if (!(joinSparitionDominantSide != null ? !joinSparitionDominantSide.equals(joinSparitionDominantSide4) : joinSparitionDominantSide4 != null)) {
                numPartitions = Predef$.MODULE$.Integer2int(sedonaConf.getFallbackPartitionNum());
                ((TraitJoinQueryBase)$this).doSpatialPartitioning((SpatialRDD<Geometry>)leftShapes, (SpatialRDD<Geometry>)rightShapes, Predef$.MODULE$.int2Integer(numPartitions), sedonaConf);
            }
            numPartitions = Predef$.MODULE$.Integer2int(sedonaConf.getFallbackPartitionNum());
            ((TraitJoinQueryBase)$this).doSpatialPartitioning((SpatialRDD<Geometry>)rightShapes, (SpatialRDD<Geometry>)leftShapes, Predef$.MODULE$.int2Integer(numPartitions), sedonaConf);
        }
        JoinQuery.JoinParams joinParams = new JoinQuery.JoinParams(Predef$.MODULE$.Boolean2boolean(sedonaConf.getUseIndex()), ((TraitJoinQueryExec)$this).intersects(), sedonaConf.getIndexType(), sedonaConf.getJoinBuildSide());
        JavaPairRDD matches2 = JoinQuery.spatialJoin((SpatialRDD)leftShapes, (SpatialRDD)rightShapes, (JoinQuery.JoinParams)joinParams);
        $this.logDebug((Function0)new Serializable($this, matches2){
            public static final long serialVersionUID = 0L;
            private final JavaPairRDD matches$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Join result has ", " rows"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.matches$1.count())}));
            }
            {
                this.matches$1 = matches$1;
            }
        });
        return matches2.rdd().mapPartitions((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparkPlan $outer;

            public final Iterator<InternalRow> apply(Iterator<Tuple2<Geometry, Geometry>> iter) {
                Iterator iterator;
                if (((TraitJoinQueryExec)this.$outer).extraCondition().isDefined()) {
                    Predicate boundCondition2 = this.$outer.newPredicate((Expression)((TraitJoinQueryExec)this.$outer).extraCondition().get(), (Seq)((TraitJoinQueryExec)this.$outer).left().output().$plus$plus((GenTraversableOnce)((TraitJoinQueryExec)this.$outer).right().output(), Seq$.MODULE$.canBuildFrom()));
                    iterator = iter.filter((Function1)new Serializable(this, boundCondition2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ TraitJoinQueryExec$.anonfun.doExecute.2 $outer;
                        private final Predicate boundCondition$1;

                        public final boolean apply(Tuple2<Geometry, Geometry> x0$1) {
                            Tuple2<Geometry, Geometry> tuple2 = x0$1;
                            if (tuple2 != null) {
                                Geometry l = (Geometry)tuple2._1();
                                Geometry r = (Geometry)tuple2._2();
                                UnsafeRow leftRow = (UnsafeRow)l.getUserData();
                                UnsafeRow rightRow = (UnsafeRow)r.getUserData();
                                UnsafeRowJoiner joiner = GenerateUnsafeRowJoiner$.MODULE$.create(((TraitJoinQueryExec)this.$outer.org$apache$spark$sql$sedona_sql$strategy$join$TraitJoinQueryExec$$anonfun$$$outer()).left().schema(), ((TraitJoinQueryExec)this.$outer.org$apache$spark$sql$sedona_sql$strategy$join$TraitJoinQueryExec$$anonfun$$$outer()).right().schema());
                                boolean bl = this.boundCondition$1.eval((InternalRow)joiner.join(leftRow, rightRow));
                                return bl;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.boundCondition$1 = boundCondition$1;
                        }
                    });
                } else {
                    iterator = iter;
                }
                Iterator filtered = iterator;
                return filtered.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ TraitJoinQueryExec$.anonfun.doExecute.2 $outer;

                    public final InternalRow apply(Tuple2<Geometry, Geometry> x0$2) {
                        Tuple2<Geometry, Geometry> tuple2 = x0$2;
                        if (tuple2 != null) {
                            Geometry l = (Geometry)tuple2._1();
                            Geometry r = (Geometry)tuple2._2();
                            UnsafeRow leftRow = (UnsafeRow)l.getUserData();
                            UnsafeRow rightRow = (UnsafeRow)r.getUserData();
                            UnsafeRowJoiner joiner = GenerateUnsafeRowJoiner$.MODULE$.create(((TraitJoinQueryExec)this.$outer.org$apache$spark$sql$sedona_sql$strategy$join$TraitJoinQueryExec$$anonfun$$$outer()).left().schema(), ((TraitJoinQueryExec)this.$outer.org$apache$spark$sql$sedona_sql$strategy$join$TraitJoinQueryExec$$anonfun$$$outer()).right().schema());
                            UnsafeRow unsafeRow = joiner.join(leftRow, rightRow);
                            return unsafeRow;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ SparkPlan org$apache$spark$sql$sedona_sql$strategy$join$TraitJoinQueryExec$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, matches2.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class));
    }

    public static int joinPartitionNumOptimizer(SparkPlan $this, int dominantSidePartNum, int followerSidePartNum, long dominantSideCount) {
        $this.log().info(new StringBuilder().append((Object)"[SedonaSQL] Dominant side count: ").append((Object)BoxesRunTime.boxToLong((long)dominantSideCount)).toString());
        int numPartition = -1;
        int candidatePartitionNum = Predef$.MODULE$.long2Long(dominantSideCount / 2L).intValue();
        if ((long)(dominantSidePartNum * 2) > dominantSideCount) {
            $this.log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[SedonaSQL] Join dominant side partition number ", " is larger than 1/2 of the dominant side count ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)dominantSidePartNum), BoxesRunTime.boxToLong((long)dominantSideCount)})));
            $this.log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[SedonaSQL] Try to use follower side partition number ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)followerSidePartNum)})));
            if ((long)(followerSidePartNum * 2) > dominantSideCount) {
                $this.log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[SedonaSQL] Join follower side partition number is also larger than 1/2 of the dominant side count ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)dominantSideCount)})));
                $this.log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[SedonaSQL] Try to use 1/2 of the dominant side count ", " as the partition number of both sides"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)candidatePartitionNum)})));
                if (candidatePartitionNum == 0) {
                    $this.log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[SedonaSQL] 1/2 of ", " is equal to 0. Use 1 as the partition number of both sides instead."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)candidatePartitionNum)})));
                    numPartition = 1;
                } else {
                    numPartition = candidatePartitionNum;
                }
            } else {
                numPartition = followerSidePartNum;
            }
        } else {
            numPartition = dominantSidePartNum;
        }
        return numPartition;
    }

    public static void $init$(SparkPlan $this) {
    }
}

