/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.strategy.join;

import org.apache.sedona.core.geometryObjects.Circle;
import org.apache.sedona.core.spatialRDD.SpatialRDD;
import org.apache.sedona.core.utils.SedonaConf;
import org.apache.sedona.sql.utils.GeometrySerializer$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.sedona_sql.strategy.join.TraitJoinQueryBase;
import org.locationtech.jts.geom.Geometry;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public abstract class TraitJoinQueryBase$class {
    public static Tuple2 toSpatialRddPair(SparkPlan $this, RDD buildRdd, Expression buildExpr, RDD streamedRdd, Expression streamedExpr) {
        return new Tuple2(((TraitJoinQueryBase)$this).toSpatialRDD((RDD<UnsafeRow>)buildRdd, buildExpr), ((TraitJoinQueryBase)$this).toSpatialRDD((RDD<UnsafeRow>)streamedRdd, streamedExpr));
    }

    /*
     * WARNING - void declaration
     */
    public static SpatialRDD toSpatialRDD(SparkPlan $this, RDD rdd, Expression shapeExpression) {
        void var3_3;
        SpatialRDD spatialRdd = new SpatialRDD();
        spatialRdd.setRawSpatialRDD(rdd.map((Function1)new Serializable($this, shapeExpression){
            public static final long serialVersionUID = 0L;
            private final Expression shapeExpression$1;

            /*
             * WARNING - void declaration
             */
            public final Geometry apply(UnsafeRow x) {
                void var2_2;
                Geometry shape = GeometrySerializer$.MODULE$.deserialize((ArrayData)this.shapeExpression$1.eval((InternalRow)x));
                shape.setUserData(x.copy());
                return var2_2;
            }
            {
                this.shapeExpression$1 = shapeExpression$1;
            }
        }, ClassTag$.MODULE$.apply(Geometry.class)).toJavaRDD());
        return var3_3;
    }

    public static SpatialRDD toCircleRDD(SparkPlan $this, RDD rdd, Expression shapeExpression, Expression boundRadius) {
        SpatialRDD spatialRdd = new SpatialRDD();
        spatialRdd.setRawSpatialRDD(rdd.map((Function1)new Serializable($this, shapeExpression, boundRadius){
            public static final long serialVersionUID = 0L;
            private final Expression shapeExpression$2;
            private final Expression boundRadius$1;

            /*
             * WARNING - void declaration
             */
            public final Geometry apply(UnsafeRow x) {
                void var3_3;
                Geometry shape = GeometrySerializer$.MODULE$.deserialize((ArrayData)this.shapeExpression$2.eval((InternalRow)x));
                Circle circle = new Circle(shape, Predef$.MODULE$.double2Double(BoxesRunTime.unboxToDouble((Object)this.boundRadius$1.eval((InternalRow)x))));
                circle.setUserData(x.copy());
                return var3_3;
            }
            {
                this.shapeExpression$2 = shapeExpression$2;
                this.boundRadius$1 = boundRadius$1;
            }
        }, ClassTag$.MODULE$.apply(Geometry.class)).toJavaRDD());
        return spatialRdd;
    }

    public static void doSpatialPartitioning(SparkPlan $this, SpatialRDD dominantShapes, SpatialRDD followerShapes, Integer numPartitions, SedonaConf sedonaConf) {
        dominantShapes.spatialPartitioning(sedonaConf.getJoinGridType(), Predef$.MODULE$.Integer2int(numPartitions));
        followerShapes.spatialPartitioning(dominantShapes.getPartitioner());
    }

    public static void $init$(SparkPlan $this) {
    }
}

