/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.sql.utils;

import org.apache.sedona.core.spatialRDD.SpatialRDD;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.sedona_sql.UDT.GeometryUDT$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.locationtech.jts.geom.Geometry;
import scala.Array$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class Adapter$ {
    public static final Adapter$ MODULE$;

    static {
        new Adapter$();
    }

    public SpatialRDD<Geometry> toSpatialRdd(Dataset<Row> dataFrame, String geometryFieldName) {
        SpatialRDD<Geometry> spatialRDD;
        if (dataFrame.schema().size() == 1) {
            spatialRDD = this.toSpatialRdd(dataFrame, 0, (Seq<String>)Nil$.MODULE$);
        } else {
            List fieldList = (List)dataFrame.schema().toList().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(StructField f) {
                    return f.name();
                }
            }, List$.MODULE$.canBuildFrom());
            spatialRDD = this.toSpatialRdd(dataFrame, geometryFieldName, (Seq<String>)((Seq)fieldList.filter((Function1)new Serializable(geometryFieldName){
                public static final long serialVersionUID = 0L;
                private final String geometryFieldName$1;

                public final boolean apply(String p) {
                    return !p.equalsIgnoreCase(this.geometryFieldName$1);
                }
                {
                    this.geometryFieldName$1 = geometryFieldName$1;
                }
            })));
        }
        return spatialRDD;
    }

    public SpatialRDD<Geometry> toSpatialRdd(Dataset<Row> dataFrame, String geometryFieldName, Seq<String> fieldNames) {
        SpatialRDD<Geometry> spatialRDD = new SpatialRDD<Geometry>();
        spatialRDD.rawSpatialRDD = this.toRdd(dataFrame, geometryFieldName).toJavaRDD();
        spatialRDD.fieldNames = fieldNames != null && fieldNames.nonEmpty() ? JavaConversions$.MODULE$.seqAsJavaList(fieldNames) : null;
        return spatialRDD;
    }

    private RDD<Geometry> toRdd(Dataset<Row> dataFrame, String geometryFieldName) {
        List fieldList = (List)dataFrame.schema().toList().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField f) {
                return f.name();
            }
        }, List$.MODULE$.canBuildFrom());
        int geomColId = fieldList.indexOf((Object)geometryFieldName);
        Predef$.MODULE$.assert(geomColId >= 0);
        return this.toRdd(dataFrame, geomColId);
    }

    public SpatialRDD<Geometry> toSpatialRdd(Dataset<Row> dataFrame, int geometryColId, Seq<String> fieldNames) {
        SpatialRDD<Geometry> spatialRDD = new SpatialRDD<Geometry>();
        spatialRDD.rawSpatialRDD = this.toRdd(dataFrame, geometryColId).toJavaRDD();
        spatialRDD.fieldNames = fieldNames.nonEmpty() ? JavaConversions$.MODULE$.seqAsJavaList(fieldNames) : null;
        return spatialRDD;
    }

    public SpatialRDD<Geometry> toSpatialRdd(Dataset<Row> dataFrame, int geometryColId) {
        SpatialRDD<Geometry> spatialRDD;
        if (dataFrame.schema().size() == 1) {
            spatialRDD = this.toSpatialRdd(dataFrame, 0, (Seq<String>)Nil$.MODULE$);
        } else {
            List fieldList = (List)dataFrame.schema().toList().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(StructField f) {
                    return f.name();
                }
            }, List$.MODULE$.canBuildFrom());
            String geometryFieldName = (String)fieldList.apply(geometryColId);
            spatialRDD = this.toSpatialRdd(dataFrame, geometryColId, (Seq<String>)((Seq)fieldList.filter((Function1)new Serializable(geometryFieldName){
                public static final long serialVersionUID = 0L;
                private final String geometryFieldName$2;

                public final boolean apply(String p) {
                    return !p.equalsIgnoreCase(this.geometryFieldName$2);
                }
                {
                    this.geometryFieldName$2 = geometryFieldName$2;
                }
            })));
        }
        return spatialRDD;
    }

    public <T extends Geometry> Dataset<Row> toDf(SpatialRDD<T> spatialRDD, SparkSession sparkSession) {
        if (spatialRDD.fieldNames == null) {
            return this.toDf(spatialRDD, null, sparkSession);
        }
        return this.toDf(spatialRDD, (Seq<String>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(spatialRDD.fieldNames).asScala()).toList(), sparkSession);
    }

    public <T extends Geometry> Dataset<Row> toDf(SpatialRDD<T> spatialRDD, Seq<String> fieldNames, SparkSession sparkSession) {
        RDD rowRdd = spatialRDD.rawSpatialRDD.rdd().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Row apply(T geom) {
                Row row;
                Object userData = ((Geometry)geom).getUserData();
                Geometry geomWithoutUserData = ((Geometry)geom).copy();
                geomWithoutUserData.setUserData(null);
                if (userData == null) {
                    row = Row$.MODULE$.fromSeq((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Geometry[]{geom})));
                } else {
                    Geometry geometry = geomWithoutUserData;
                    row = Row$.MODULE$.fromSeq((Seq)Predef$.MODULE$.refArrayOps((Object[])((String)userData).split("\t", -1)).$plus$colon((Object)geometry, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())));
                }
                return row;
            }
        }, ClassTag$.MODULE$.apply(Row.class));
        Seq cols = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("geometry", (DataType)GeometryUDT$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}));
        if (fieldNames != null && fieldNames.nonEmpty()) {
            cols = (Seq)cols.$plus$plus((GenTraversableOnce)fieldNames.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final StructField apply(String f) {
                    return new StructField(f, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                }
            }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        }
        StructType schema = StructType$.MODULE$.apply(cols);
        return sparkSession.createDataFrame(rowRdd, schema);
    }

    public Dataset<Row> toDf(JavaPairRDD<Geometry, Geometry> spatialPairRDD, SparkSession sparkSession) {
        return this.toDf(spatialPairRDD, null, null, sparkSession);
    }

    public Dataset<Row> toDf(JavaPairRDD<Geometry, Geometry> spatialPairRDD, Seq<String> leftFieldnames, Seq<String> rightFieldNames, SparkSession sparkSession) {
        RDD rowRdd = spatialPairRDD.rdd().map((Function1)new Serializable(leftFieldnames, rightFieldNames){
            public static final long serialVersionUID = 0L;
            private final Seq leftFieldnames$1;
            private final Seq rightFieldNames$1;

            public final Row apply(Tuple2<Geometry, Geometry> f) {
                Tuple2<Seq<Geometry>, Seq<String>> left = Adapter$.MODULE$.org$apache$sedona$sql$utils$Adapter$$getGeomAndFields((Geometry)f._1(), (Seq<String>)this.leftFieldnames$1);
                Tuple2<Seq<Geometry>, Seq<String>> right = Adapter$.MODULE$.org$apache$sedona$sql$utils$Adapter$$getGeomAndFields((Geometry)f._2(), (Seq<String>)this.rightFieldNames$1);
                return Row$.MODULE$.fromSeq((Seq)((TraversableLike)((TraversableLike)((TraversableLike)left._1()).$plus$plus((GenTraversableOnce)left._2(), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)right._1(), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)right._2(), Seq$.MODULE$.canBuildFrom()));
            }
            {
                this.leftFieldnames$1 = leftFieldnames$1;
                this.rightFieldNames$1 = rightFieldNames$1;
            }
        }, ClassTag$.MODULE$.apply(Row.class));
        Seq cols = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("leftgeometry", (DataType)GeometryUDT$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}));
        if (leftFieldnames != null && leftFieldnames.nonEmpty()) {
            cols = (Seq)cols.$plus$plus((GenTraversableOnce)leftFieldnames.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final StructField apply(String fName) {
                    return new StructField(fName, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                }
            }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        }
        cols = (Seq)cols.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("rightgeometry", (DataType)GeometryUDT$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})), Seq$.MODULE$.canBuildFrom());
        if (rightFieldNames != null && rightFieldNames.nonEmpty()) {
            cols = (Seq)cols.$plus$plus((GenTraversableOnce)rightFieldNames.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final StructField apply(String fName) {
                    return new StructField(fName, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                }
            }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        }
        StructType schema = StructType$.MODULE$.apply(cols);
        return sparkSession.createDataFrame(rowRdd, schema);
    }

    private RDD<Geometry> toRdd(Dataset<Row> dataFrame, int geometryColId) {
        return dataFrame.rdd().map((Function1)new Serializable(geometryColId){
            public static final long serialVersionUID = 0L;
            private final int geometryColId$1;

            /*
             * WARNING - void declaration
             */
            public final Geometry apply(Row f) {
                void var2_2;
                Geometry geometry = (Geometry)f.get(this.geometryColId$1);
                int fieldSize = f.size();
                ObjectRef userData = ObjectRef.create(null);
                if (fieldSize > 1) {
                    userData.elem = "";
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.geometryColId$1).foreach$mVc$sp((Function1)new Serializable(this, userData, f){
                        public static final long serialVersionUID = 0L;
                        private final ObjectRef userData$1;
                        private final Row f$1;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.userData$1.elem = new StringBuilder().append((Object)((String)this.userData$1.elem)).append((Object)Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(this.f$1.get(i)), "\t")).toString();
                        }
                        {
                            this.userData$1 = userData$1;
                            this.f$1 = f$1;
                        }
                    });
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.geometryColId$1 + 1), f.size()).foreach$mVc$sp((Function1)new Serializable(this, userData, f){
                        public static final long serialVersionUID = 0L;
                        private final ObjectRef userData$1;
                        private final Row f$1;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.userData$1.elem = new StringBuilder().append((Object)((String)this.userData$1.elem)).append((Object)Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(this.f$1.get(i)), "\t")).toString();
                        }
                        {
                            this.userData$1 = userData$1;
                            this.f$1 = f$1;
                        }
                    });
                    userData.elem = (String)new StringOps(Predef$.MODULE$.augmentString((String)userData.elem)).dropRight(1);
                }
                geometry.setUserData((String)userData.elem);
                return var2_2;
            }
            {
                this.geometryColId$1 = geometryColId$1;
            }
        }, ClassTag$.MODULE$.apply(Geometry.class));
    }

    public Tuple2<Seq<Geometry>, Seq<String>> org$apache$sedona$sql$utils$Adapter$$getGeomAndFields(Geometry geom, Seq<String> fieldNames) {
        Tuple2 tuple2;
        if (fieldNames != null && fieldNames.nonEmpty()) {
            String userData = String.valueOf((String)geom.getUserData());
            String[] fields = userData.split("\t");
            Geometry geomWithoutUserData = geom.copy();
            geomWithoutUserData.setUserData(null);
            tuple2 = new Tuple2((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Geometry[]{geomWithoutUserData})), (Object)Predef$.MODULE$.wrapRefArray((Object[])fields));
        } else {
            tuple2 = new Tuple2((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Geometry[]{geom})), (Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
        }
        return tuple2;
    }

    private Adapter$() {
        MODULE$ = this;
    }
}

