/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.strategy.join;

import java.io.Serializable;
import org.apache.sedona.core.enums.JoinSparitionDominantSide;
import org.apache.sedona.core.spatialOperator.JoinQuery;
import org.apache.sedona.core.spatialRDD.SpatialRDD;
import org.apache.sedona.core.utils.SedonaConf;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.BasePredicate;
import org.apache.spark.sql.catalyst.expressions.BindReferences$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Predicate$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeRowJoiner$;
import org.apache.spark.sql.catalyst.expressions.codegen.UnsafeRowJoiner;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.sedona_sql.strategy.join.TraitJoinQueryBase;
import org.locationtech.jts.geom.Geometry;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a\u0001\u0003\u0007\u000e!\u0003\r\t\u0001\b@\t\u000b\u001d\u0002A\u0011\u0001\u0015\t\u00111\u0002\u0001R1A\u0005\n5BqA\u0010\u0001C\u0002\u001b\u0005q\bC\u0004G\u0001\t\u0007i\u0011A \t\u000f\u001d\u0003!\u0019!D\u0001\u0011\"9q\n\u0001b\u0001\u000e\u0003A\u0005b\u0002)\u0001\u0005\u00045\t!\u0015\u0005\b%\u0002\u0011\rQ\"\u0001T\u0011\u00159\u0006\u0001\"\u0011Y\u0011\u0015A\u0007\u0001\"\u0015j\u0011\u0015\u0001\b\u0001\"\u0001r\u0005I!&/Y5u\u0015>Lg.U;fef,\u00050Z2\u000b\u00059y\u0011\u0001\u00026pS:T!\u0001E\t\u0002\u0011M$(/\u0019;fOfT!AE\n\u0002\u0015M,Gm\u001c8b?N\fHN\u0003\u0002\u0015+\u0005\u00191/\u001d7\u000b\u0005Y9\u0012!B:qCJ\\'B\u0001\r\u001a\u0003\u0019\t\u0007/Y2iK*\t!$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001;\r\u0002\"AH\u0011\u000e\u0003}Q\u0011\u0001I\u0001\u0006g\u000e\fG.Y\u0005\u0003E}\u0011a!\u00118z%\u00164\u0007C\u0001\u0013&\u001b\u0005i\u0011B\u0001\u0014\u000e\u0005I!&/Y5u\u0015>Lg.U;fef\u0014\u0015m]3\u0002\r\u0011Jg.\u001b;%)\u0005I\u0003C\u0001\u0010+\u0013\tYsD\u0001\u0003V]&$\u0018A\u00042pk:$7i\u001c8eSRLwN\\\u000b\u0002]A!adL\u00198\u0013\t\u0001tDA\u0005Gk:\u001cG/[8ocA\u0011!'N\u0007\u0002g)\u0011AgE\u0001\tG\u0006$\u0018\r\\=ti&\u0011ag\r\u0002\f\u0013:$XM\u001d8bYJ{w\u000f\u0005\u0002\u001fq%\u0011\u0011h\b\u0002\b\u0005>|G.Z1oQ\t\u00111\b\u0005\u0002\u001fy%\u0011Qh\b\u0002\niJ\fgn]5f]R\fA\u0001\\3giV\t\u0001\t\u0005\u0002B\t6\t!I\u0003\u0002D'\u0005IQ\r_3dkRLwN\\\u0005\u0003\u000b\n\u0013\u0011b\u00159be.\u0004F.\u00198\u0002\u000bILw\r\u001b;\u0002\u00131,g\r^*iCB,W#A%\u0011\u0005)kU\"A&\u000b\u00051\u001b\u0014aC3yaJ,7o]5p]NL!AT&\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0006sS\u001eDGo\u00155ba\u0016\f!\"\u001b8uKJ\u001cXm\u0019;t+\u00059\u0014AD3yiJ\f7i\u001c8eSRLwN\\\u000b\u0002)B\u0019a$V%\n\u0005Y{\"AB(qi&|g.\u0001\u0004pkR\u0004X\u000f^\u000b\u00023B\u0019!LY3\u000f\u0005m\u0003gB\u0001/`\u001b\u0005i&B\u00010\u001c\u0003\u0019a$o\\8u}%\t\u0001%\u0003\u0002b?\u00059\u0001/Y2lC\u001e,\u0017BA2e\u0005\r\u0019V-\u001d\u0006\u0003C~\u0001\"A\u00134\n\u0005\u001d\\%!C!uiJL'-\u001e;f\u0003%!w.\u0012=fGV$X\rF\u0001k!\rYg.M\u0007\u0002Y*\u0011Q.F\u0001\u0004e\u0012$\u0017BA8m\u0005\r\u0011F\tR\u0001\u001aU>Lg\u000eU1si&$\u0018n\u001c8Ok6|\u0005\u000f^5nSj,'\u000f\u0006\u0003sk^L\bC\u0001\u0010t\u0013\t!xDA\u0002J]RDQA^\u0006A\u0002I\f1\u0003Z8nS:\fg\u000e^*jI\u0016\u0004\u0016M\u001d;Ok6DQ\u0001_\u0006A\u0002I\f1CZ8mY><XM]*jI\u0016\u0004\u0016M\u001d;Ok6DQA_\u0006A\u0002m\f\u0011\u0003Z8nS:\fg\u000e^*jI\u0016\u001cu.\u001e8u!\tqB0\u0003\u0002~?\t!Aj\u001c8h%\u0011y\u00181\u0001!\u0007\u000b\u0005\u0005\u0001\u0001\u0001@\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0011\u0005\u0011\u0002\u0001")
public interface TraitJoinQueryExec
extends TraitJoinQueryBase {
    public static /* synthetic */ Function1 org$apache$spark$sql$sedona_sql$strategy$join$TraitJoinQueryExec$$boundCondition$(TraitJoinQueryExec $this) {
        return $this.org$apache$spark$sql$sedona_sql$strategy$join$TraitJoinQueryExec$$boundCondition();
    }

    default public Function1<InternalRow, Object> org$apache$spark$sql$sedona_sql$strategy$join$TraitJoinQueryExec$$boundCondition() {
        Function1 & Serializable & scala.Serializable intersect;
        if (this.extraCondition().isDefined()) {
            BasePredicate basePredicate = Predicate$.MODULE$.create((Expression)this.extraCondition().get(), (Seq)this.left().output().$plus$plus((GenTraversableOnce)this.right().output(), Seq$.MODULE$.canBuildFrom()));
            intersect = (Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)basePredicate.eval(r));
        } else {
            intersect = (Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)TraitJoinQueryExec.$anonfun$boundCondition$2(r));
        }
        return intersect;
    }

    public SparkPlan left();

    public SparkPlan right();

    public Expression leftShape();

    public Expression rightShape();

    public boolean intersects();

    public Option<Expression> extraCondition();

    public static /* synthetic */ Seq output$(TraitJoinQueryExec $this) {
        return $this.output();
    }

    default public Seq<Attribute> output() {
        return (Seq)this.left().output().$plus$plus((GenTraversableOnce)this.right().output(), Seq$.MODULE$.canBuildFrom());
    }

    public static /* synthetic */ RDD doExecute$(TraitJoinQueryExec $this) {
        return $this.doExecute();
    }

    default public RDD<InternalRow> doExecute() {
        Expression boundLeftShape = BindReferences$.MODULE$.bindReference(this.leftShape(), package$.MODULE$.AttributeSeq(this.left().output()), BindReferences$.MODULE$.bindReference$default$3());
        Expression boundRightShape = BindReferences$.MODULE$.bindReference(this.rightShape(), package$.MODULE$.AttributeSeq(this.right().output()), BindReferences$.MODULE$.bindReference$default$3());
        RDD leftResultsRaw = this.left().execute();
        RDD rightResultsRaw = this.right().execute();
        SedonaConf sedonaConf = new SedonaConf(((SparkPlan)this).sparkContext().conf());
        Tuple2<SpatialRDD<Geometry>, SpatialRDD<Geometry>> tuple2 = this.toSpatialRddPair((RDD<UnsafeRow>)leftResultsRaw, boundLeftShape, (RDD<UnsafeRow>)rightResultsRaw, boundRightShape);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        SpatialRDD leftShapes = (SpatialRDD)tuple2._1();
        SpatialRDD rightShapes = (SpatialRDD)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)leftShapes, (Object)rightShapes);
        Tuple2 tuple23 = tuple22;
        SpatialRDD leftShapes2 = (SpatialRDD)tuple23._1();
        SpatialRDD rightShapes2 = (SpatialRDD)tuple23._2();
        if (BoxesRunTime.equalsNumObject((Number)sedonaConf.getJoinApproximateTotalCount(), (Object)BoxesRunTime.boxToInteger((int)-1))) {
            JoinSparitionDominantSide joinSparitionDominantSide = sedonaConf.getJoinSparitionDominantSide();
            JoinSparitionDominantSide joinSparitionDominantSide2 = JoinSparitionDominantSide.LEFT;
            if (!(joinSparitionDominantSide != null ? !joinSparitionDominantSide.equals(joinSparitionDominantSide2) : joinSparitionDominantSide2 != null)) {
                leftShapes2.analyze();
                sedonaConf.setJoinApproximateTotalCount(Predef$.MODULE$.long2Long(leftShapes2.approximateTotalCount));
                sedonaConf.setDatasetBoundary(leftShapes2.boundaryEnvelope);
            } else {
                rightShapes2.analyze();
                sedonaConf.setJoinApproximateTotalCount(Predef$.MODULE$.long2Long(rightShapes2.approximateTotalCount));
                sedonaConf.setDatasetBoundary(rightShapes2.boundaryEnvelope);
            }
        }
        ((Logging)this).log().info(new StringBuilder(46).append("[SedonaSQL] Number of partitions on the left: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])leftResultsRaw.partitions())).size()).toString());
        ((Logging)this).log().info(new StringBuilder(47).append("[SedonaSQL] Number of partitions on the right: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rightResultsRaw.partitions())).size()).toString());
        int numPartitions = -1;
        try {
            JoinSparitionDominantSide joinSparitionDominantSide = sedonaConf.getJoinSparitionDominantSide();
            JoinSparitionDominantSide joinSparitionDominantSide3 = JoinSparitionDominantSide.LEFT;
            if (!(joinSparitionDominantSide != null ? !joinSparitionDominantSide.equals(joinSparitionDominantSide3) : joinSparitionDominantSide3 != null)) {
                numPartitions = !BoxesRunTime.equalsNumObject((Number)sedonaConf.getFallbackPartitionNum(), (Object)BoxesRunTime.boxToInteger((int)-1)) ? Predef$.MODULE$.Integer2int(sedonaConf.getFallbackPartitionNum()) : this.joinPartitionNumOptimizer(leftShapes2.rawSpatialRDD.partitions().size(), rightShapes2.rawSpatialRDD.partitions().size(), leftShapes2.approximateTotalCount);
                this.doSpatialPartitioning((SpatialRDD<Geometry>)leftShapes2, (SpatialRDD<Geometry>)rightShapes2, Predef$.MODULE$.int2Integer(numPartitions), sedonaConf);
            } else {
                if (!BoxesRunTime.equalsNumObject((Number)sedonaConf.getFallbackPartitionNum(), (Object)BoxesRunTime.boxToInteger((int)-1))) {
                    numPartitions = Predef$.MODULE$.Integer2int(sedonaConf.getFallbackPartitionNum());
                } else {
                    numPartitions = rightShapes2.rawSpatialRDD.partitions().size();
                    numPartitions = this.joinPartitionNumOptimizer(rightShapes2.rawSpatialRDD.partitions().size(), leftShapes2.rawSpatialRDD.partitions().size(), rightShapes2.approximateTotalCount);
                }
                this.doSpatialPartitioning((SpatialRDD<Geometry>)rightShapes2, (SpatialRDD<Geometry>)leftShapes2, Predef$.MODULE$.int2Integer(numPartitions), sedonaConf);
            }
        }
        catch (IllegalArgumentException e) {
            Predef$.MODULE$.print((Object)e.getMessage());
            JoinSparitionDominantSide joinSparitionDominantSide = sedonaConf.getJoinSparitionDominantSide();
            JoinSparitionDominantSide joinSparitionDominantSide4 = JoinSparitionDominantSide.LEFT;
            if (!(joinSparitionDominantSide != null ? !joinSparitionDominantSide.equals(joinSparitionDominantSide4) : joinSparitionDominantSide4 != null)) {
                numPartitions = Predef$.MODULE$.Integer2int(sedonaConf.getFallbackPartitionNum());
                this.doSpatialPartitioning((SpatialRDD<Geometry>)leftShapes2, (SpatialRDD<Geometry>)rightShapes2, Predef$.MODULE$.int2Integer(numPartitions), sedonaConf);
            }
            numPartitions = Predef$.MODULE$.Integer2int(sedonaConf.getFallbackPartitionNum());
            this.doSpatialPartitioning((SpatialRDD<Geometry>)rightShapes2, (SpatialRDD<Geometry>)leftShapes2, Predef$.MODULE$.int2Integer(numPartitions), sedonaConf);
        }
        JoinQuery.JoinParams joinParams = new JoinQuery.JoinParams(Predef$.MODULE$.Boolean2boolean(sedonaConf.getUseIndex()), this.intersects(), sedonaConf.getIndexType(), sedonaConf.getJoinBuildSide());
        JavaPairRDD matches = JoinQuery.spatialJoin((SpatialRDD)leftShapes2, (SpatialRDD)rightShapes2, (JoinQuery.JoinParams)joinParams);
        ((Logging)this).logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Join result has ").append(matches.count()).append(" rows").toString());
        return matches.rdd().mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            Iterator iterator;
            if (this.extraCondition().isDefined()) {
                BasePredicate boundCondition = Predicate$.MODULE$.create((Expression)this.extraCondition().get(), (Seq)this.left().output().$plus$plus((GenTraversableOnce)this.right().output(), Seq$.MODULE$.canBuildFrom()));
                iterator = iter.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)TraitJoinQueryExec.$anonfun$doExecute$3(this, boundCondition, x0$1)));
            } else {
                iterator = iter;
            }
            Iterator filtered = iterator;
            return filtered.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Geometry l = (Geometry)tuple2._1();
                Geometry r = (Geometry)tuple2._2();
                UnsafeRow leftRow = (UnsafeRow)l.getUserData();
                UnsafeRow rightRow = (UnsafeRow)r.getUserData();
                UnsafeRowJoiner joiner = GenerateUnsafeRowJoiner$.MODULE$.create(this.left().schema(), this.right().schema());
                UnsafeRow unsafeRow = joiner.join(leftRow, rightRow);
                return unsafeRow;
            });
        }, matches.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class));
    }

    public static /* synthetic */ int joinPartitionNumOptimizer$(TraitJoinQueryExec $this, int dominantSidePartNum, int followerSidePartNum, long dominantSideCount) {
        return $this.joinPartitionNumOptimizer(dominantSidePartNum, followerSidePartNum, dominantSideCount);
    }

    default public int joinPartitionNumOptimizer(int dominantSidePartNum, int followerSidePartNum, long dominantSideCount) {
        ((Logging)this).log().info(new StringBuilder(33).append("[SedonaSQL] Dominant side count: ").append(dominantSideCount).toString());
        int numPartition = -1;
        int candidatePartitionNum = Predef$.MODULE$.long2Long(dominantSideCount / 2L).intValue();
        if ((long)(dominantSidePartNum * 2) > dominantSideCount) {
            ((Logging)this).log().warn(new StringBuilder(95).append("[SedonaSQL] Join dominant side partition number ").append(dominantSidePartNum).append(" is larger than 1/2 of the dominant side count ").append(dominantSideCount).toString());
            ((Logging)this).log().warn(new StringBuilder(54).append("[SedonaSQL] Try to use follower side partition number ").append(followerSidePartNum).toString());
            if ((long)(followerSidePartNum * 2) > dominantSideCount) {
                ((Logging)this).log().warn(new StringBuilder(99).append("[SedonaSQL] Join follower side partition number is also larger than 1/2 of the dominant side count ").append(dominantSideCount).toString());
                ((Logging)this).log().warn(new StringBuilder(92).append("[SedonaSQL] Try to use 1/2 of the dominant side count ").append(candidatePartitionNum).append(" as the partition number of both sides").toString());
                if (candidatePartitionNum == 0) {
                    ((Logging)this).log().warn(new StringBuilder(87).append("[SedonaSQL] 1/2 of ").append(candidatePartitionNum).append(" is equal to 0. Use 1 as the partition number of both sides instead.").toString());
                    numPartition = 1;
                } else {
                    numPartition = candidatePartitionNum;
                }
            } else {
                numPartition = followerSidePartNum;
            }
        } else {
            numPartition = dominantSidePartNum;
        }
        return numPartition;
    }

    public static /* synthetic */ boolean $anonfun$boundCondition$2(InternalRow r) {
        return true;
    }

    public static /* synthetic */ boolean $anonfun$doExecute$3(TraitJoinQueryExec $this, BasePredicate boundCondition$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Geometry l = (Geometry)tuple2._1();
        Geometry r = (Geometry)tuple2._2();
        UnsafeRow leftRow = (UnsafeRow)l.getUserData();
        UnsafeRow rightRow = (UnsafeRow)r.getUserData();
        UnsafeRowJoiner joiner = GenerateUnsafeRowJoiner$.MODULE$.create($this.left().schema(), $this.right().schema());
        boolean bl = boundCondition$1.eval((InternalRow)joiner.join(leftRow, rightRow));
        return bl;
    }

    public static void $init$(TraitJoinQueryExec $this) {
    }
}

