/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.spatialOperator;

import java.io.Serializable;
import org.apache.sedona.core.rangeJudgement.RangeFilter;
import org.apache.sedona.core.rangeJudgement.RangeFilterUsingIndex;
import org.apache.sedona.core.spatialRDD.SpatialRDD;
import org.apache.sedona.core.utils.CRSTransformation;
import org.apache.spark.api.java.JavaRDD;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;

public class RangeQuery
implements Serializable {
    public static <U extends Geometry, T extends Geometry> JavaRDD<T> SpatialRangeQuery(SpatialRDD<T> spatialRDD, U originalQueryGeometry, boolean considerBoundaryIntersection, boolean useIndex) throws Exception {
        U queryGeometry = originalQueryGeometry;
        if (spatialRDD.getCRStransformation()) {
            queryGeometry = CRSTransformation.Transform(spatialRDD.getSourceEpsgCode(), spatialRDD.getTargetEpgsgCode(), originalQueryGeometry);
        }
        if (useIndex) {
            if (spatialRDD.indexedRawRDD == null) {
                throw new Exception("[RangeQuery][SpatialRangeQuery] Index doesn't exist. Please build index on rawSpatialRDD.");
            }
            return spatialRDD.indexedRawRDD.mapPartitions(new RangeFilterUsingIndex(queryGeometry, considerBoundaryIntersection, true));
        }
        return spatialRDD.getRawSpatialRDD().filter(new RangeFilter(queryGeometry, considerBoundaryIntersection, true));
    }

    public static <U extends Geometry, T extends Geometry> JavaRDD<T> SpatialRangeQuery(SpatialRDD<T> spatialRDD, Envelope queryWindow, boolean considerBoundaryIntersection, boolean useIndex) throws Exception {
        Coordinate[] coordinates;
        coordinates = new Coordinate[]{new Coordinate(queryWindow.getMinX(), queryWindow.getMinY()), new Coordinate(queryWindow.getMinX(), queryWindow.getMaxY()), new Coordinate(queryWindow.getMaxX(), queryWindow.getMaxY()), new Coordinate(queryWindow.getMaxX(), queryWindow.getMinY()), coordinates[0]};
        GeometryFactory geometryFactory = new GeometryFactory();
        Polygon queryGeometry = geometryFactory.createPolygon(coordinates);
        return RangeQuery.SpatialRangeQuery(spatialRDD, queryGeometry, considerBoundaryIntersection, useIndex);
    }

    public static <U extends Geometry, T extends Geometry> JavaRDD<T> SpatialRangeQuery(Envelope queryWindow, SpatialRDD<T> spatialRDD, boolean considerBoundaryIntersection, boolean useIndex) throws Exception {
        Coordinate[] coordinates;
        coordinates = new Coordinate[]{new Coordinate(queryWindow.getMinX(), queryWindow.getMinY()), new Coordinate(queryWindow.getMinX(), queryWindow.getMaxY()), new Coordinate(queryWindow.getMaxX(), queryWindow.getMaxY()), new Coordinate(queryWindow.getMaxX(), queryWindow.getMinY()), coordinates[0]};
        GeometryFactory geometryFactory = new GeometryFactory();
        Polygon queryGeometry = geometryFactory.createPolygon(coordinates);
        return RangeQuery.SpatialRangeQuery(queryGeometry, spatialRDD, considerBoundaryIntersection, useIndex);
    }

    public static <U extends Geometry, T extends Geometry> JavaRDD<T> SpatialRangeQuery(U originalQueryGeometry, SpatialRDD<T> spatialRDD, boolean considerBoundaryIntersection, boolean useIndex) throws Exception {
        U queryGeometry = originalQueryGeometry;
        if (spatialRDD.getCRStransformation()) {
            queryGeometry = CRSTransformation.Transform(spatialRDD.getSourceEpsgCode(), spatialRDD.getTargetEpgsgCode(), originalQueryGeometry);
        }
        if (useIndex) {
            if (spatialRDD.indexedRawRDD == null) {
                throw new Exception("[RangeQuery][SpatialRangeQuery] Index doesn't exist. Please build index on rawSpatialRDD.");
            }
            return spatialRDD.indexedRawRDD.mapPartitions(new RangeFilterUsingIndex(queryGeometry, considerBoundaryIntersection, false));
        }
        return spatialRDD.getRawSpatialRDD().filter(new RangeFilter(queryGeometry, considerBoundaryIntersection, false));
    }
}

