/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.geometryObjects;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Point;
import org.wololo.geojson.Geometry;
import org.wololo.geojson.GeometryCollection;
import org.wololo.geojson.LineString;
import org.wololo.geojson.MultiPoint;
import org.wololo.geojson.MultiPolygon;
import org.wololo.geojson.Polygon;
import org.wololo.jts2geojson.GeoJSONReader;

public class GeoJSONWriterNew {
    static final GeoJSONReader reader = new GeoJSONReader();

    public Geometry write(org.locationtech.jts.geom.Geometry geometry) {
        Class<?> c = geometry.getClass();
        if (c.equals(Point.class)) {
            return this.convert((Point)geometry);
        }
        if (c.equals(org.locationtech.jts.geom.LineString.class)) {
            return this.convert((org.locationtech.jts.geom.LineString)geometry);
        }
        if (c.equals(org.locationtech.jts.geom.Polygon.class)) {
            return this.convert((org.locationtech.jts.geom.Polygon)geometry);
        }
        if (c.equals(org.locationtech.jts.geom.MultiPoint.class)) {
            return this.convert((org.locationtech.jts.geom.MultiPoint)geometry);
        }
        if (c.equals(MultiLineString.class)) {
            return this.convert((MultiLineString)geometry);
        }
        if (c.equals(org.locationtech.jts.geom.MultiPolygon.class)) {
            return this.convert((org.locationtech.jts.geom.MultiPolygon)geometry);
        }
        if (c.equals(org.locationtech.jts.geom.GeometryCollection.class)) {
            return this.convert((org.locationtech.jts.geom.GeometryCollection)geometry);
        }
        throw new UnsupportedOperationException();
    }

    org.wololo.geojson.Point convert(Point point) {
        org.wololo.geojson.Point json = new org.wololo.geojson.Point(this.convert(point.getCoordinate()));
        return json;
    }

    MultiPoint convert(org.locationtech.jts.geom.MultiPoint multiPoint) {
        return new MultiPoint(this.convert(multiPoint.getCoordinates()));
    }

    LineString convert(org.locationtech.jts.geom.LineString lineString) {
        return new LineString(this.convert(lineString.getCoordinates()));
    }

    org.wololo.geojson.MultiLineString convert(MultiLineString multiLineString) {
        int size = multiLineString.getNumGeometries();
        double[][][] lineStrings = new double[size][][];
        for (int i = 0; i < size; ++i) {
            lineStrings[i] = this.convert(multiLineString.getGeometryN(i).getCoordinates());
        }
        return new org.wololo.geojson.MultiLineString(lineStrings);
    }

    Polygon convert(org.locationtech.jts.geom.Polygon polygon) {
        int size = polygon.getNumInteriorRing() + 1;
        double[][][] rings = new double[size][][];
        rings[0] = this.convert(polygon.getExteriorRing().getCoordinates());
        for (int i = 0; i < size - 1; ++i) {
            rings[i + 1] = this.convert(polygon.getInteriorRingN(i).getCoordinates());
        }
        return new Polygon(rings);
    }

    MultiPolygon convert(org.locationtech.jts.geom.MultiPolygon multiPolygon) {
        int size = multiPolygon.getNumGeometries();
        double[][][][] polygons = new double[size][][][];
        for (int i = 0; i < size; ++i) {
            polygons[i] = this.convert((org.locationtech.jts.geom.Polygon)multiPolygon.getGeometryN(i)).getCoordinates();
        }
        return new MultiPolygon(polygons);
    }

    GeometryCollection convert(org.locationtech.jts.geom.GeometryCollection gc) {
        int size = gc.getNumGeometries();
        Geometry[] geometries = new Geometry[size];
        for (int i = 0; i < size; ++i) {
            geometries[i] = this.write(gc.getGeometryN(i));
        }
        return new GeometryCollection(geometries);
    }

    double[] convert(Coordinate coordinate) {
        if (Double.isNaN(coordinate.getZ())) {
            return new double[]{coordinate.x, coordinate.y};
        }
        return new double[]{coordinate.x, coordinate.y, coordinate.getZ()};
    }

    double[][] convert(Coordinate[] coordinates) {
        double[][] array = new double[coordinates.length][];
        for (int i = 0; i < coordinates.length; ++i) {
            array[i] = this.convert(coordinates[i]);
        }
        return array;
    }
}

