/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.joinJudgement;

import java.io.Serializable;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.sedona.core.joinJudgement.DedupParams;
import org.apache.sedona.core.utils.HalfOpenRectangle;
import org.apache.spark.TaskContext;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;

abstract class JudgementBase
implements Serializable {
    private static final Logger log = LogManager.getLogger(JudgementBase.class);
    private final boolean considerBoundaryIntersection;
    private final DedupParams dedupParams;
    private transient HalfOpenRectangle extent;

    protected JudgementBase(boolean considerBoundaryIntersection, @Nullable DedupParams dedupParams) {
        this.considerBoundaryIntersection = considerBoundaryIntersection;
        this.dedupParams = dedupParams;
    }

    protected void initPartition() {
        List<Envelope> partitionExtents;
        if (this.dedupParams == null) {
            return;
        }
        int partitionId = TaskContext.getPartitionId();
        if (partitionId < (partitionExtents = this.dedupParams.getPartitionExtents()).size()) {
            this.extent = new HalfOpenRectangle(partitionExtents.get(partitionId));
        } else {
            log.warn((Object)("Didn't find partition extent for this partition: " + partitionId));
        }
    }

    protected boolean match(Geometry left, Geometry right) {
        if (this.extent != null) {
            Point referencePoint;
            if (left instanceof Point || right instanceof Point) {
                return this.geoMatch(left, right);
            }
            Envelope intersection = left.getEnvelopeInternal().intersection(right.getEnvelopeInternal());
            if (!intersection.isNull() && !this.extent.contains(referencePoint = this.makePoint(intersection.getMinX(), intersection.getMinY(), left.getFactory()))) {
                return false;
            }
        }
        return this.geoMatch(left, right);
    }

    private Point makePoint(double x, double y, GeometryFactory factory) {
        return factory.createPoint(new Coordinate(x, y));
    }

    private boolean geoMatch(Geometry left, Geometry right) {
        return this.considerBoundaryIntersection ? left.intersects(right) : left.covers(right);
    }
}

